/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.template;

import com.atlassian.confluence.jmx.CurrentTimeFacade;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class MultipartBuilder {
    public static final MultipartBuilder INSTANCE = new MultipartBuilder();

    public MimeMultipart makeMultipart(ByteArrayInputStream bytezIn) throws MessagingException, IOException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messagePart = new MimeBodyPart();
        messagePart.setText("Log file(s) zip :");
        multipart.addBodyPart((BodyPart)messagePart);
        MimeBodyPart filePart = new MimeBodyPart();
        filePart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(bytezIn, "application/octet-stream")));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        filePart.setFileName("logs-" + format.format(CurrentTimeFacade.getCurrentTime()) + ".zip");
        multipart.addBodyPart((BodyPart)filePart);
        return multipart;
    }

    public Multipart buildMartipart(String location) throws IOException, MessagingException {
        List list = this.getResourcesFromPath(location);
        if (list.size() == 0) {
            throw new IOException("Unable to read logs or no logs present at location  :  " + location);
        }
        ByteArrayOutputStream myout = this.extractZippedBytes(list);
        ByteArrayInputStream bytezIn = new ByteArrayInputStream(myout.toByteArray());
        MimeMultipart multipart = this.makeMultipart(bytezIn);
        return multipart;
    }

    ByteArrayOutputStream extractZippedBytes(List resources) throws IOException {
        ByteArrayOutputStream myout = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(myout));
        for (Resource resource : resources) {
            ZipEntry entry = new ZipEntry(resource.getFilename());
            out.putNextEntry(entry);
            IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)out);
        }
        out.close();
        return myout;
    }

    public List getResourcesFromPath(String location) {
        File f = new File(location);
        File[] fileza = f.listFiles((FilenameFilter)new SuffixFileFilter("log"));
        if (fileza == null) {
            return new ArrayList();
        }
        Arrays.sort(fileza, new Comparator(){

            public int compare(Object o, Object o2) {
                long l = ((File)o2).lastModified();
                Long aLong = new Long(((File)o).lastModified());
                return new Long(l).compareTo(aLong);
            }
        });
        ArrayList<FileSystemResource> filez = new ArrayList<FileSystemResource>();
        for (int i = 0; i < fileza.length && i < 2; ++i) {
            FileSystemResource o = new FileSystemResource(fileza[i]);
            filez.add(o);
        }
        return filez;
    }

    private static class ByteArrayDataSource
    implements DataSource {
        private ByteArrayOutputStream baos = null;
        private String type = "application/octet-stream";

        public ByteArrayDataSource(InputStream aIs, String type) throws IOException {
            this.byteArrayDataSource(aIs, type);
        }

        private void byteArrayDataSource(InputStream aIs, String type) throws IOException {
            this.type = type;
            this.baos = new ByteArrayOutputStream();
            boolean i = false;
            IOUtils.copy((InputStream)aIs, (OutputStream)this.baos);
            this.baos.close();
        }

        public String getContentType() {
            return this.type == null ? "application/octet-stream" : this.type;
        }

        public InputStream getInputStream() throws IOException {
            if (this.baos == null) {
                throw new IOException("no data");
            }
            return new ByteArrayInputStream(this.baos.toByteArray());
        }

        public String getName() {
            return "ByteArrayDataSource";
        }

        public OutputStream getOutputStream() throws IOException {
            this.baos = new ByteArrayOutputStream();
            return this.baos;
        }
    }
}

