/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.template;

import com.atlassian.confluence.mail.template.MailNotificationQueueItem;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.user.User;
import java.util.Map;

public class PreRenderedMailNotificationQueueItem
extends MailNotificationQueueItem
implements MailQueueItem {
    private String renderedSubject;
    private String mimeType;
    private final String email;

    private PreRenderedMailNotificationQueueItem(User user, String templateLocation, String templateFileName, String subject) {
        super(user, templateLocation, templateFileName, subject);
        this.email = user.getEmail();
        this.mimeType = this.getMimeType();
    }

    private PreRenderedMailNotificationQueueItem(User user, String templateContent, String subject) {
        super(user, templateContent, subject);
        this.email = user.getEmail();
    }

    public static MailNotificationQueueItem createFromTemplateFile(User user, String templateFileName, String subject) {
        String templateType = "text";
        if (PreRenderedMailNotificationQueueItem.getMimeTypeForUser(user).equals("text/html")) {
            templateType = "html";
        }
        String templateLocation = "/templates/email/" + templateType + "/";
        return PreRenderedMailNotificationQueueItem.createFromTemplateFileAndLocation(user, templateLocation, templateFileName, subject);
    }

    public static PreRenderedMailNotificationQueueItem createFromTemplateFileAndContext(User user, String templateFileName, String subject, Map contextMap) {
        String templateType = "text";
        if ("text/html".equals(PreRenderedMailNotificationQueueItem.getMimeTypeForUser(user))) {
            templateType = "html";
        }
        String templateLocation = "/templates/email/" + templateType + "/";
        PreRenderedMailNotificationQueueItem preRenderedMailQueueItem = (PreRenderedMailNotificationQueueItem)PreRenderedMailNotificationQueueItem.createFromTemplateFileAndLocation(user, templateLocation, templateFileName, subject);
        preRenderedMailQueueItem.preRenderBody(contextMap);
        preRenderedMailQueueItem.setRenderedSubject(subject);
        return preRenderedMailQueueItem;
    }

    public static MailNotificationQueueItem createFromTemplateFileAndLocation(User user, String templateLocation, String templateFileName, String subject) {
        return new PreRenderedMailNotificationQueueItem(user, templateLocation, templateFileName, subject);
    }

    public static MailNotificationQueueItem createFromTemplateContent(User user, String templateContent, String subject) {
        return new PreRenderedMailNotificationQueueItem(user, templateContent, subject);
    }

    public void render() {
        this.renderedSubject = this.getRenderedContent(this.getSubject());
        this.addVelocityContextParam("subject", this.renderedSubject);
        this.body = this.getRenderedContent();
        this.clearContext();
    }

    public final void send() throws MailException {
        if (this.body == null) {
            throw new IllegalStateException("Prerendered Queue Item has not been rendered");
        }
        super.send();
    }

    protected Email createMailObject() {
        Email mail = new Email(this.email);
        mail.setEncoding("UTF-8");
        mail.setSubject(this.renderedSubject);
        mail.setBody(this.body);
        mail.setMimeType(this.mimeType);
        return mail;
    }

    public void setRenderedSubject(String renderedSubject) {
        this.renderedSubject = renderedSubject;
    }
}

