/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.exception.InfrastructureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPage
extends SpaceContentEntityObject {
    private static final char[] invalidTitleCharacters = new char[]{':', ';', '<', '>', '@', '/', '\\', '|', '#', '[', ']', '{', '}', '^'};
    private List comments = new ArrayList();

    public static boolean isValidPageTitle(String title) {
        return AbstractPage.isValidTitleLength(title) && !AbstractPage.hasInvalidTitleCharacters(title);
    }

    public static boolean isValidTitleLength(String title) {
        return title != null && title.length() <= 255;
    }

    public static boolean hasInvalidTitleCharacters(String title) {
        if (title.startsWith("~") || title.startsWith("$") || title.startsWith("..")) {
            return true;
        }
        for (int i = 0; i < title.length(); ++i) {
            if (AbstractPage.isValidPageTitleCharacter(title.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidPageTitleCharacter(char c) {
        for (int i = 0; i < invalidTitleCharacters.length; ++i) {
            if (c != invalidTitleCharacters[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setTitle(String title) {
        if (title != null && AbstractPage.hasInvalidTitleCharacters(title)) {
            throw new InfrastructureException("Invalid page title: " + title);
        }
        super.setTitle(title);
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List comments) {
        this.comments = comments;
    }

    public void addComment(Comment comment) {
        if (!this.getComments().contains(comment)) {
            this.getComments().add(comment);
        }
        comment.setPage(this);
    }

    public void removeComment(Comment comment) {
        comment.reparentChildren(comment.getParent());
        if (comment.getParent() != null) {
            comment.getParent().removeChild(comment);
        }
        this.getComments().remove(comment);
    }

    @Override
    public void convertToHistoricalVersion() {
        super.convertToHistoricalVersion();
        this.setAttachments(new ArrayList());
        this.setComments(new ArrayList());
    }

    public AbstractPage getOriginalVersionPage() {
        return (AbstractPage)this.getOriginalVersion();
    }

    public void setOriginalVersionPage(AbstractPage originalVersionPage) {
        this.setOriginalVersion(originalVersionPage);
    }

    public int getPreviousVersion() {
        return this.getVersion() - 1;
    }

    public void remove(PageManager pageManager) {
        NotificationManager manager = pageManager.getNotificationManager();
        List notifs = manager.getNotificationsByPage(this);
        Iterator iter = notifs.iterator();
        while (iter.hasNext()) {
            manager.removeNotification((Notification)iter.next());
        }
        for (Attachment attachment : this.getLatestVersionsOfAttachments()) {
            pageManager.getAttachmentManager().removeAttachmentFromServer(attachment);
        }
        pageManager.removeContentEntity(this);
    }

    @Override
    public Collection getSearchableDependants() {
        ArrayList<Comment> dependants = new ArrayList<Comment>();
        dependants.addAll(this.getComments());
        dependants.addAll(this.getAttachments());
        return dependants;
    }

    @Override
    public String getUrlPath() {
        return GeneralUtil.getPageUrl(this);
    }

    public List getTopLevelComments() {
        ArrayList<Comment> topLevelComments = new ArrayList<Comment>();
        for (Comment comment : this.getComments()) {
            if (comment.getParent() != null) continue;
            topLevelComments.add(comment);
        }
        return topLevelComments;
    }

    @Override
    public String getAttachmentsUrlPath() {
        return "/pages/viewpageattachments.action?pageId=" + this.getId();
    }
}

