/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.confluence.core.AbstractVersionedEntityObject;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AttachmentUtils;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.FileSize;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class Attachment
extends AbstractVersionedEntityObject
implements SearchableAttachment,
Addressable {
    private String fileName;
    private String contentType;
    private ContentEntityObject content;
    private long fileSize;
    private String comment;
    public static final String CONTENT_TYPE = "attachment";
    public static final String PROFILE_PICTURE_COMMENT = "Uploaded Profile Picture";

    public Attachment() {
    }

    public Attachment(String fileName, String contentType, long fileSize, String comment) {
        this.fileName = fileName;
        this.contentType = contentType;
        this.fileSize = fileSize;
        this.comment = comment;
    }

    public Integer getAttachmentVersion() {
        return new Integer(this.getVersion());
    }

    public void setAttachmentVersion(Integer attachmentVersion) {
        this.setVersion(attachmentVersion != null ? attachmentVersion : 1);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ContentEntityObject getContent() {
        return this.content;
    }

    public void setContent(ContentEntityObject content) {
        this.content = content;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getNiceFileSize() {
        return FileSize.format((long)this.getFileSize());
    }

    public String getNiceType() {
        return Attachment.getDescriptionForMimeType(this.getContentType(), this.getFileExtension());
    }

    public String getType() {
        return CONTENT_TYPE;
    }

    public String getRealTitle() {
        return this.getDisplayTitle();
    }

    public String getDisplayTitle() {
        return this.getFileName();
    }

    public String getUrlPath() {
        if (TextUtils.stringSet((String)this.getContent().getAttachmentsUrlPath())) {
            if ("mail".equals(this.getContent().getType())) {
                return GeneralUtil.appendAmpsandOrQuestionMark(this.getContent().getUrlPath()) + "highlight=" + GeneralUtil.urlEncode(this.getFileName()) + "#attachments";
            }
            if (this.isUserProfilePicture()) {
                return this.getContent().getUrlPath();
            }
            return this.getContent().getAttachmentsUrlPath() + "&highlight=" + GeneralUtil.urlEncode(this.getFileName()) + "#" + GeneralUtil.urlEncode(this.getContent().getTitle()) + "-attachment-" + GeneralUtil.urlEncode(this.getFileName());
        }
        return "/" + this.getFileName();
    }

    public Collection getSearchableDependants() {
        return Collections.EMPTY_LIST;
    }

    public boolean isUserProfilePicture() {
        if (TextUtils.stringSet((String)this.comment)) {
            return this.comment.equals(PROFILE_PICTURE_COMMENT) && "userinfo".equals(this.content.getType());
        }
        return false;
    }

    public boolean isIndexable() {
        return this.isLatestVersion() && this.getContent() != null && this.getContent().getContentStatus().equals("current") && !(this.getContent() instanceof Draft);
    }

    public String getDownloadPath() {
        return this.getDownloadPathWithoutVersion() + "?version=" + Integer.toString(this.getVersion());
    }

    public String getDownloadPathWithoutVersion() {
        return "/download/attachments/" + this.getContent().getId() + "/" + GeneralUtil.urlEncode(this.getFileName());
    }

    public InputStream getContentsAsStream() throws IOException {
        return AttachmentUtils.getLatestAttachmentStream(this);
    }

    public String toString() {
        return "Attachment: " + this.getFileName() + " v." + this.getVersion() + " (" + this.getId() + ")";
    }

    private String getSpaceKey() {
        if (this.getContent() instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)this.getContent()).getSpaceKey();
        }
        return null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attachment)) {
            return false;
        }
        return super.equals(o);
    }

    public String getFileExtension() {
        String fileName = this.getFileName();
        if (fileName == null) {
            return "";
        }
        int indexOfDot = fileName.lastIndexOf(".");
        if (indexOfDot == -1) {
            return "";
        }
        return fileName.substring(indexOfDot + 1).toLowerCase();
    }

    public static String getDescriptionForMimeType(String mimeType, String fileExtension) {
        if (StringUtils.isBlank((String)mimeType)) {
            return null;
        }
        if (mimeType.equals("application/pdf")) {
            return "PDF Document";
        }
        if (mimeType.startsWith("image")) {
            return "Image";
        }
        if (mimeType.equals("text/xml")) {
            return "XML File";
        }
        if (mimeType.equals("text/html")) {
            return "HTML Document";
        }
        if (mimeType.equals("text/plain")) {
            return "Text File";
        }
        if (mimeType.equals("application/msword")) {
            return "Word Document";
        }
        if ("doc".equals(fileExtension)) {
            return "Word Document";
        }
        if (mimeType.equals("application/vnd.ms-excel")) {
            return "Excel Spreadsheet";
        }
        if ("xls".equals(fileExtension)) {
            return "Excel Spreadsheet";
        }
        if (mimeType.equals("application/vnd.ms-powerpoint")) {
            return "PowerPoint Presentation";
        }
        if ("ppt".equals(fileExtension)) {
            return "PowerPoint Presentation";
        }
        if ("java".equals(fileExtension)) {
            return "Java Source File";
        }
        if ("png".equals(fileExtension)) {
            return "Image";
        }
        if ("zip".equals(fileExtension)) {
            return "Zip Archive";
        }
        return null;
    }
}

