/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.io.InputStream;
import org.apache.log4j.Category;

public class AttachmentUtils {
    protected static Category log = Category.getInstance(AttachmentUtils.class);

    public static File getOldContainingFolder(Attachment attachment) {
        boolean result;
        File containingFolder = new File(AttachmentUtils.getConfluenceAttachmentDirectory() + "/" + attachment.getContent().getId() + "/" + attachment.getFileName());
        if (!containingFolder.exists() && !(result = containingFolder.mkdirs())) {
            log.error((Object)("Containing folders " + containingFolder.getAbsolutePath() + " for the attachment " + attachment.getFileName() + " could not be created"));
        }
        return containingFolder;
    }

    public static File getContainingFolder(Attachment attachment) {
        boolean result;
        File containingFolder = new File(AttachmentUtils.getConfluenceAttachmentDirectory() + "/" + attachment.getContent().getId() + "/" + attachment.getId());
        if (!containingFolder.exists() && !(result = containingFolder.mkdirs())) {
            log.error((Object)("Containing folders " + containingFolder.getAbsolutePath() + " for the attachment " + attachment.getFileName() + " could not be created"));
        }
        return containingFolder;
    }

    public static InputStream getLatestAttachmentStream(Attachment attachment) {
        AttachmentManager attachmentManager = (AttachmentManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"attachmentManager");
        if (attachmentManager == null) {
            throw new IllegalStateException("Could not retrieve the attachmentManager from the application context!");
        }
        return attachmentManager.getAttachmentData(attachment);
    }

    public static String getConfluenceAttachmentDirectory() {
        return BootstrapUtils.getBootstrapManager().getFilePathProperty("attachments.dir");
    }
}

