/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.core.util.DateUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class BlogPostsCalendar {
    private List[] postsPerDay = new List[32];
    private Calendar calendar;
    private String spaceKey;
    private BlogPost lastPostInPreviousMonth;
    private BlogPost firstPostInNextMonth;

    public BlogPostsCalendar(Date coversDate, List blogPosts, String spaceKey) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(coversDate);
        this.calendar = DateUtils.toStartOfPeriod((Calendar)cal, (int)2);
        this.spaceKey = spaceKey;
        for (BlogPost post : blogPosts) {
            int i = this.getDayOfMonth(post);
            if (i < 1) continue;
            if (this.postsPerDay[i] == null) {
                this.postsPerDay[i] = new ArrayList();
            }
            this.postsPerDay[i].add(post);
        }
        for (int i = 0; i < this.postsPerDay.length; ++i) {
            List list = this.postsPerDay[i];
            if (list != null) continue;
            this.postsPerDay[i] = Collections.EMPTY_LIST;
        }
    }

    private int getDayOfMonth(BlogPost post) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(post.getCreationDate());
        if (cal.get(2) == this.calendar.get(2)) {
            return cal.get(5);
        }
        return -1;
    }

    public int getDaysInMonth() {
        return this.calendar.getActualMaximum(5);
    }

    public int getStartingDayOfMonth() {
        return this.calendar.get(7) - 1;
    }

    public List getPostsForDay(int dayOfMonth) {
        return this.postsPerDay[dayOfMonth];
    }

    public String formatMonthYear() {
        return new SimpleDateFormat("MMMM yyyy").format(this.calendar.getTime());
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getPreviousMonth() {
        return this.getRelativeYearMonth(-1);
    }

    public String getNextMonth() {
        return this.getRelativeYearMonth(1);
    }

    public String getCurrentMonth() {
        return this.getRelativeYearMonth(0);
    }

    private String getRelativeYearMonth(int offset) {
        Calendar c = Calendar.getInstance();
        c.setTime(this.calendar.getTime());
        c.add(2, offset);
        return new SimpleDateFormat("yyyy/MM").format(c.getTime());
    }

    public void setLastPostInPreviousMonth(BlogPost lastPostInPreviousMonth) {
        this.lastPostInPreviousMonth = lastPostInPreviousMonth;
    }

    public void setFirstPostInNextMonth(BlogPost firstPostInNextMonth) {
        this.firstPostInNextMonth = firstPostInNextMonth;
    }

    public BlogPost getLastPostInPreviousMonth() {
        return this.lastPostInPreviousMonth;
    }

    public BlogPost getFirstPostInNextMonth() {
        return this.firstPostInNextMonth;
    }
}

