/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultContentEntityManager;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.persistence.dao.CommentDao;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.Event;
import java.util.Iterator;

public class DefaultCommentManager
extends DefaultContentEntityManager
implements CommentManager {
    private CommentDao commentDao;

    public void setCommentDao(CommentDao commentDao) {
        this.commentDao = commentDao;
    }

    public Comment getComment(long id) {
        return this.commentDao.getById(id);
    }

    public Comment addCommentToPage(AbstractPage page, Comment parent, String content) {
        Comment comment = new Comment();
        comment.setContent(content);
        page.addComment(comment);
        this.commentDao.save(comment);
        if (parent != null) {
            parent.addChild(comment);
        }
        this.linkManager.updateOutgoingLinks(comment);
        this.getEventManager().publishEvent((Event)new CommentCreateEvent(this, comment));
        return comment;
    }

    public void updateCommentContent(Comment comment, String content) {
        Comment originalComment = null;
        try {
            originalComment = (Comment)comment.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("The Comment class does NOT support cloning ??! How come?", e);
        }
        comment.setContent(content);
        this.saveContentEntity(comment, originalComment, null);
    }

    public void removeCommentFromPage(long id) {
        Comment comment = this.getComment(id);
        if (comment == null) {
            return;
        }
        comment.getPage().removeComment(comment);
        this.removeContentEntity(comment);
    }

    public Iterator getRecentlyUpdatedComments(Space space, int maxResults) {
        return this.commentDao.getRecentlyUpdatedComments(space.getId(), maxResults);
    }

    protected void publishCreateEvent(ContentEntityObject obj) {
        this.eventManager.publishEvent((Event)new CommentCreateEvent(this, (Comment)obj));
    }

    protected void publishRemoveEvent(ContentEntityObject obj) {
        this.eventManager.publishEvent((Event)new CommentRemoveEvent(this, (Comment)obj, AuthenticatedUserThreadLocal.getUser()));
    }

    protected void publishUpdateEvent(ContentEntityObject obj, ContentEntityObject origObj, SaveContext saveContext) {
        this.eventManager.publishEvent((Event)new CommentUpdateEvent(this, (Comment)obj, (Comment)origObj));
    }
}

