/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;

public class TreeBuilder {
    private final User user;
    private final ContentPermissionManager contentPermissionManager;
    private final PageManager pageManager;

    public TreeBuilder(User user, ContentPermissionManager contentPermissionManager, PageManager pageManager) {
        this.user = user;
        this.contentPermissionManager = contentPermissionManager;
        this.pageManager = pageManager;
    }

    public ContentTree createPageTree(Space space) {
        ContentTree contentTree = new ContentTree(this.getSortedTopLevelPages(space));
        for (ContentNode contentNode : contentTree.getRootNodes()) {
            this.addSortedChildren(contentNode);
        }
        return contentTree;
    }

    public List getSortedTopLevelPages(Space space) {
        ArrayList<ContentNode> result = new ArrayList<ContentNode>();
        List topLevelPages = this.pageManager.getTopLevelPages(space);
        for (Page rootPage : topLevelPages) {
            if (!this.contentPermissionManager.hasContentLevelPermission(this.user, "View", rootPage)) continue;
            result.add(new ContentNode(rootPage));
        }
        return result;
    }

    private void addSortedChildren(ContentNode contentNode) {
        List pageChildren = contentNode.getPage().getSortedChildren();
        for (Page child : pageChildren) {
            if (!this.contentPermissionManager.hasContentLevelPermission(this.user, "View", child)) continue;
            ContentNode contentChildNode = new ContentNode(child);
            contentNode.addChild(contentChildNode);
            this.addSortedChildren(contentChildNode);
        }
    }
}

