/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.util.DateUtils;
import com.atlassian.renderer.RenderContext;
import java.util.Calendar;

public class AbstractBlogPostsAction
extends AbstractSpaceAction {
    protected PageManager pageManager;
    private BlogPost firstPostInNextMonth;
    private BlogPost lastPostInPreviousMonth;

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @HtmlSafe
    public String renderBlogPost(BlogPost post) {
        if (post == null) {
            return "";
        }
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)post.toPageContext(), post.getContent());
    }

    public BlogPost getFirstPostInNextMonth(Calendar postingDate) {
        if (this.firstPostInNextMonth == null) {
            Calendar postDate = (Calendar)postingDate.clone();
            DateUtils.toEndOfPeriod((Calendar)postDate, (int)2);
            this.firstPostInNextMonth = this.pageManager.findNextBlogPost(this.getKey(), postDate.getTime());
        }
        return this.firstPostInNextMonth;
    }

    public BlogPost getLastPostInPreviousMonth(Calendar postingDate) {
        if (this.lastPostInPreviousMonth == null) {
            Calendar postDate = (Calendar)postingDate.clone();
            DateUtils.toStartOfPeriod((Calendar)postDate, (int)2);
            this.lastPostInPreviousMonth = this.pageManager.findPreviousBlogPost(this.getKey(), postDate.getTime());
        }
        return this.lastPostInPreviousMonth;
    }
}

