/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractCreateAndEditPageAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.Spaced;
import com.atlassian.confluence.util.LabelUtil;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCreatePageAction
extends AbstractCreateAndEditPageAction
implements Spaced {
    public static final String INPUT_VARIABLES = "inputvariables";
    private boolean invalidPageTitle;
    private Space space;
    private Space newSpace;
    private String spaceKey;
    private long fromPageId;
    private Page fromPage;
    private String titleWritten = "";
    private PageService pageService;
    private SpaceService spaceService;
    private AttachmentManager attachmentManager;

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getSpaceKey() {
        if (TextUtils.stringSet((String)this.spaceKey)) {
            return this.spaceKey;
        }
        return super.getSpaceKey();
    }

    public Space getSpace() {
        if (this.space == null) {
            this.space = super.getSpace();
        }
        if (this.space == null && TextUtils.stringSet((String)this.spaceKey)) {
            this.space = this.spaceManager.getSpace(this.spaceKey);
        }
        return this.space;
    }

    public Space getNewSpace() {
        if (this.newSpace == null && TextUtils.stringSet((String)this.newSpaceKey)) {
            this.newSpace = this.spaceManager.getSpace(this.newSpaceKey);
        }
        return this.newSpace;
    }

    public String doDefault() throws Exception {
        this.loadTemplates();
        this.createDraftIfItDoesNotExist();
        return super.doDefault();
    }

    protected void createDraftIfItDoesNotExist() {
    }

    public void setTitle(String title) {
        title = title.trim();
        this.invalidPageTitle = AbstractPage.hasInvalidTitleCharacters(title);
        super.setTitle(title);
    }

    public String doAdd() throws Exception {
        this.loadTemplates();
        if (TextUtils.stringSet((String)this.back)) {
            return "input";
        }
        if (TextUtils.stringSet((String)this.preview)) {
            this.updateXHtmlContent();
            this.setInPreview(true);
            return PREVIEW;
        }
        if (this.templateId != null && !this.getText("no-template").equals(this.templateId)) {
            return INPUT_VARIABLES;
        }
        this.createPage();
        List editPermissions = this.createEditPermissions();
        List viewPermissions = this.createViewPermissions();
        this.setPermissions(editPermissions);
        this.setPermissions(viewPermissions);
        this.pageManager.saveContentEntity(this.getPage(), null);
        this.transferDraftAttachments();
        this.contentPermissionManager.setContentPermissions(editPermissions, this.getPage(), "Edit");
        this.contentPermissionManager.setContentPermissions(viewPermissions, this.getPage(), "View");
        if (StringUtils.isNotEmpty((String)this.getPosition())) {
            this.setPageLocation();
        }
        this.onAddComplete();
        LabelUtil.syncState(this.getLabelsString(), this.getLabelManager(), this.getRemoteUser(), this.getPage(), true);
        return "success";
    }

    private void setPageLocation() {
        if ("topLevel".equals(this.getPosition())) {
            this.pageService.newMovePageCommand(this.pageService.getIdPageLocator(this.getPageId()), this.spaceService.getKeySpaceLocator(this.getNewSpaceKey())).execute();
        } else {
            this.pageService.newMovePageCommand(this.pageService.getIdPageLocator(this.getPageId()), this.pageService.getIdPageLocator(this.targetId), this.getPosition()).execute();
        }
    }

    protected void onAddComplete() {
        this.draftManager.removeDraft("0", this.getRemoteUser() == null ? null : this.getRemoteUser().getName(), this.getContentType());
    }

    protected void transferDraftAttachments() {
        String userName = this.getRemoteUser() == null ? null : this.getRemoteUser().getName();
        Draft draft = this.draftManager.findDraft("0", userName, this.getContentType());
        if (draft != null) {
            ArrayList attachments = new ArrayList(draft.getLatestVersionsOfAttachments());
            for (Attachment attachment : attachments) {
                this.attachmentManager.moveAttachment(attachment, attachment.getFileName(), this.getPage());
            }
        }
    }

    public void createPage() throws IOException {
        AbstractPage page = this.getPageToCreate();
        page.setTitle(this.getTitle());
        page.setContent(this.content);
        Space sp = this.getNewSpace();
        if (sp == null) {
            sp = this.spaceManager.getSpace(this.getSpaceKey());
        }
        page.setSpace(sp);
        this.setPage(page);
    }

    protected abstract AbstractPage getPageToCreate();

    public boolean isInvalidPageTitle() {
        return this.invalidPageTitle;
    }

    public boolean isPageRequired() {
        return false;
    }

    public void setFromPageId(long fromPageId) {
        this.fromPageId = fromPageId;
    }

    public long getFromPageId() {
        return this.fromPageId;
    }

    public Page getFromPage() {
        if (this.fromPage == null && this.fromPageId != 0L) {
            this.fromPage = this.pageManager.getPage(this.fromPageId);
        }
        if (this.getSpace() == null) {
            return null;
        }
        if (this.fromPage != null && !this.getSpace().getKey().equalsIgnoreCase(this.getSpaceKey())) {
            return null;
        }
        return this.fromPage;
    }

    public Page getPageToReturnToOnCancel() {
        if (this.fromPageId != 0L) {
            return this.pageManager.getPage(this.fromPageId);
        }
        return null;
    }

    protected String getContentType() {
        return this.getPageToCreate().getType();
    }

    protected boolean titleIsSetToDefault(String defaultTitleKey) {
        return this.getText(defaultTitleKey).equals(this.getTitle()) && "false".equals(this.titleWritten);
    }

    public void setTitleWritten(String titleWritten) {
        this.titleWritten = titleWritten;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }
}

