/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.util.DiffResult;
import com.atlassian.confluence.util.DiffUtils;
import com.atlassian.confluence.util.GeneralUtil;
import org.apache.commons.jrcs.diff.Diff;

public abstract class AbstractDiffPagesAction
extends AbstractPageAwareAction {
    protected AbstractPage originalPage;
    protected DiffResult diff;
    protected PageManager pageManager;

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public abstract AbstractPage getOriginalPage();

    public AbstractPage getRevisedPage() {
        return this.getPage();
    }

    public AbstractPage getLatestVersion() {
        return (AbstractPage)this.getRevisedPage().getLatestVersion();
    }

    public String getDiff() {
        return this.diff.getHtml();
    }

    public DiffResult getDiffResult() {
        return this.diff;
    }

    public String execute() throws Exception {
        this.diff = DiffUtils.generateDiff(this.getOriginalPage(), this.getRevisedPage());
        return "success";
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        return super.isPermitted() && this.originalPageIsNullOrPermitted();
    }

    private boolean originalPageIsNullOrPermitted() {
        return this.getOriginalPage() == null || this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, this.getOriginalPage().getLatestVersion());
    }

    protected static interface DiffStrategy {
        public Diff getDiff();

        public AbstractPage getOriginalPage();

        public AbstractPage getRevisedPage();
    }
}

