/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.BreadcrumbsManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.pages.actions.TinyUrlAware;
import com.atlassian.confluence.pages.actions.beans.AvailableSpaces;
import com.atlassian.confluence.pages.actions.beans.PageIncomingLinks;
import com.atlassian.confluence.pages.actions.beans.SuggestedLabels;
import com.atlassian.confluence.pages.wysiwyg.ConfluenceWysiwygConverter;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.editor.Editor;
import com.atlassian.confluence.plugin.editor.EditorManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.themes.PageHelper;
import com.atlassian.confluence.themes.ThemeHelper;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.webwork.ServletActionContext;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPageAction
extends AbstractPageAwareAction
implements PageAware,
TinyUrlAware {
    protected PageManager pageManager;
    protected LinkManager linkManager;
    protected List incomingLinks;
    private Date postingDate = null;
    private BlogPost nextPost;
    private BlogPost previousPost;
    private List availableSpaces;
    private List permittedChildren;
    protected boolean isXHtml;
    protected ConfluenceWysiwygConverter wysiwygConverter;
    private String mode = null;
    public static String RICHTEXT = "richtext";
    public static String MARKUP = "markup";
    public static String PREVIEW = "preview";
    private BreadcrumbsManager breadcrumbsManager;
    private EditorManager editorManager;

    public String getPostingDay() {
        return BlogPost.toDatePath(this.getPostingDate());
    }

    public boolean displayDatePath() {
        return this.getPage() != null && this.getPage() instanceof BlogPost;
    }

    public String getPostingYear() {
        return this.formatPostingDate("yyyy");
    }

    public String getPostingMonth() {
        return this.formatPostingDate("MMMM");
    }

    public String getPostingMonthNumeric() {
        return this.formatPostingDate("MM");
    }

    public String getPostingDayOfMonth() {
        return this.formatPostingDate("dd");
    }

    public BlogPost getBlogPost() {
        return (BlogPost)this.getPage();
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public List<OutgoingLink> getIncomingLinks() {
        return new PageIncomingLinks(this.linkManager, this.permissionManager).getIncomingLinks(this.getPage(), this.getRemoteUser());
    }

    protected List getPermissionTypes() {
        List<String> permissionTypes = super.getPermissionTypes();
        permissionTypes.add("VIEWSPACE");
        return permissionTypes;
    }

    public Date getPostingDate() {
        if (this.postingDate == null && this.getPage() != null) {
            return this.getPage().getCreationDate();
        }
        return this.postingDate;
    }

    public void setPostingDate(Date date) {
        this.postingDate = date;
    }

    public BlogPost getNextPost() {
        if (this.nextPost == null && this.getPage() instanceof BlogPost) {
            BlogPost post = (BlogPost)this.getPage().getLatestVersion();
            this.nextPost = this.pageManager.findNextBlogPost(post);
        }
        return this.nextPost;
    }

    public BlogPost getPreviousPost() {
        if (this.previousPost == null && this.getPage() instanceof BlogPost) {
            BlogPost post = (BlogPost)this.getPage().getLatestVersion();
            this.previousPost = this.pageManager.findPreviousBlogPost(post);
        }
        return this.previousPost;
    }

    @Override
    public String getTinyUrl() {
        if (this.getPage() == null) {
            return null;
        }
        return new TinyUrl(this.getPage()).getIdentifier();
    }

    private String formatPostingDate(String format) {
        if (this.getPostingDate() == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(this.getPostingDate());
    }

    protected boolean isSpaceAdmin() {
        return GeneralUtil.isSuperUser(this.getRemoteUser()) || this.spacePermissionManager.hasPermission(Collections.singletonList("SETSPACEPERMISSIONS"), this.getSpace(), this.getRemoteUser());
    }

    public boolean hasSetPagePermissionsPermission() {
        return GeneralUtil.isSuperUser(this.getRemoteUser()) || this.isSpaceAdmin() || this.spacePermissionManager.hasPermission(Collections.singletonList("SETPAGEPERMISSIONS"), this.getSpace(), this.getRemoteUser());
    }

    public List getAvailableSpaces() {
        return new AvailableSpaces(this.spaceManager).getAvailableSpaces(this.getSpace(), this.getRemoteUser());
    }

    public AbstractPage getPreviousVersion(int version) {
        return this.pageManager.getPageByVersion(this.getPage(), version);
    }

    protected Object getBeanKey() {
        return "confluence.edit.page.bean" + this.getPage().getId();
    }

    public String generateAncestryBreadcrumbs() {
        return this.breadcrumbsManager.generateAncestryBreadcrumbsForPage(this.getPageId());
    }

    @Override
    public ThemeHelper getHelper() {
        return new PageHelper(this);
    }

    public List getPermittedChildren() {
        if (!(this.getPage() instanceof Page)) {
            return Collections.EMPTY_LIST;
        }
        if (this.permittedChildren == null) {
            this.permittedChildren = this.getPage() instanceof Page ? this.contentPermissionManager.getPermittedChildren((Page)this.getPage(), this.getRemoteUser()) : Collections.EMPTY_LIST;
        }
        return this.permittedChildren;
    }

    public boolean hasPermittedChildren() {
        return this.getPermittedChildren().size() > 0;
    }

    public boolean hasAttachFilePermissions() {
        return GeneralUtil.isSuperUser(this.getRemoteUser()) || this.permissionManager.hasCreatePermission(this.getRemoteUser(), this.getPage(), Attachment.class);
    }

    public void setXhtml(boolean XHtml) {
        this.isXHtml = XHtml;
    }

    public boolean getXhtml() {
        return this.isXHtml;
    }

    public void setConfluenceWysiwygConverter(ConfluenceWysiwygConverter wysiwygConverter) {
        this.wysiwygConverter = wysiwygConverter;
    }

    public boolean getUseWysiwyg() {
        return this.getGlobalSettings().isEnableWysiwyg() && this.getSupportWysiwyg();
    }

    public boolean getSupportWysiwyg() {
        return this.getEditor() != null && this.getEditor().supportedUserAgent(ServletActionContext.getRequest().getHeader("User-Agent"));
    }

    public boolean getShowMarkup() {
        return MARKUP.equals(this.getMode());
    }

    public String getMode() {
        if (PREVIEW.equals(this.mode) && (this.getActionErrors().size() > 0 || this.getFieldErrors().size() > 0)) {
            this.mode = null;
        }
        if (this.mode == null) {
            boolean useWysiwyg = this.wysiwygConverter.getUserWysiwygPreference();
            if (useWysiwyg && this.getUseWysiwyg()) {
                this.setMode(RICHTEXT);
            } else {
                this.setMode(MARKUP);
            }
        }
        return this.mode;
    }

    public List getSuggestedLabels() {
        if (this.getPage() != null) {
            return new SuggestedLabels(this.labelManager).getSuggestedLabelsForPage(this.getPage(), this.getRemoteUser());
        }
        return new SuggestedLabels(this.labelManager).getSuggestedLabelsForSpace(this.getSpaceKey(), this.getRemoteUser());
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setBreadcrumbsManager(BreadcrumbsManager breadcrumbsManager) {
        this.breadcrumbsManager = breadcrumbsManager;
    }

    public static String getRICHTEXT() {
        return RICHTEXT;
    }

    public static String getMARKUP() {
        return MARKUP;
    }

    public static String getPREVIEW() {
        return PREVIEW;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public Editor getEditor() {
        return this.editorManager.getCurrentEditor();
    }

    public String getEditorVersion() {
        return this.editorManager.getCurrentEditorVersion();
    }

    public void setEditorManager(EditorManager editorManager) {
        this.editorManager = editorManager;
    }

    @Override
    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = new DefaultWebInterfaceContext(super.getWebInterfaceContext());
        result.setParameter("tinyUrl", Boolean.TRUE);
        return result;
    }
}

