/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.GeneralUtil;

public abstract class AbstractPageAwareAction
extends ConfluenceActionSupport
implements PageAware {
    private AbstractPage page;
    protected SpaceManager spaceManager;
    protected ContentPermissionManager contentPermissionManager;

    public AbstractPage getPage() {
        return this.page;
    }

    public long getPageId() {
        if (this.getPage() != null) {
            return this.getPage().getId();
        }
        return 0L;
    }

    public String getTitle() {
        if (this.getPage() != null) {
            return this.getPage().getTitle();
        }
        return null;
    }

    public void setPage(AbstractPage page) {
        this.page = page;
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isPermitted() {
        return GeneralUtil.isSuperUser(this.getRemoteUser()) || this.spacePermissionManager.hasPermission(this.getPermissionTypes(), this.getSpace(), this.getRemoteUser()) && this.hasViewPagePermission();
    }

    public Space getSpace() {
        if (this.getPage() != null) {
            return ((AbstractPage)this.getPage().getLatestVersion()).getSpace();
        }
        return null;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    protected boolean hasViewPagePermission() {
        return !(this.getPage() instanceof Page) || this.contentPermissionManager.hasContentLevelPermission(this.getRemoteUser(), "View", (ContentEntityObject)this.getPage().getLatestVersion());
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    public String getSpaceKey() {
        if (this.getSpace() != null) {
            return this.getSpace().getKey();
        }
        return null;
    }
}

