/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.pages.actions.beans.AttachmentStorer;
import com.atlassian.confluence.util.AttachFileHelper;
import com.atlassian.confluence.util.AttachmentComparator;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.event.Event;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewAttachmentsAction
extends ConfluenceActionSupport
implements ServletRequestAware {
    protected AttachmentManager attachmentManager;
    private FileUploadManager fileUploadManager;
    private HttpServletRequest multiPartRequest;
    protected List<String> highlight = new ArrayList<String>();
    private String sortBy = "date";

    public void setServletRequest(HttpServletRequest httpServletRequest) {
        this.multiPartRequest = httpServletRequest;
    }

    public MultiPartRequestWrapper getMultiPartRequest() {
        return (MultiPartRequestWrapper)this.multiPartRequest;
    }

    public String execute() throws Exception {
        if (!this.hasAttachFilePermissions()) {
            return "error";
        }
        if (!(this.multiPartRequest instanceof MultiPartRequestWrapper)) {
            return "input";
        }
        AttachFileHelper attachFileHelper = new AttachFileHelper((MultiPartRequestWrapper)this.multiPartRequest, this.getMaxAttachments());
        AttachmentStorer storer = new AttachmentStorer(attachFileHelper);
        storer.setAttachmentManager(this.attachmentManager);
        storer.setFileUploadManager(this.fileUploadManager);
        List<Attachment> attachmentsAdded = storer.attachFiles(this.getContentEntityObject());
        this.highlight = storer.getGetFilenamesSuccessfullyAttached();
        if (attachFileHelper.getErrors().size() > 0) {
            this.setActionErrors(attachFileHelper.getErrors());
        }
        if (attachmentsAdded.size() > 0) {
            this.getEventManager().publishEvent((Event)new AttachmentCreateEvent((Object)this, attachmentsAdded));
        }
        if (this.getActionErrors().size() > 0) {
            return "input";
        }
        return "success";
    }

    public abstract boolean hasAttachFilePermissions();

    public abstract ContentEntityObject getContentEntityObject();

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public List<Attachment> getLatestVersionsOfAttachments() {
        List<Attachment> latestVersionsOfAttachments = this.attachmentManager.getLatestVersionsOfAttachments(this.getContentEntityObject());
        if (TextUtils.stringSet((String)this.sortBy)) {
            boolean reverseMode = true;
            if ("name".equals(this.sortBy)) {
                reverseMode = false;
            }
            Collections.sort(latestVersionsOfAttachments, new AttachmentComparator(this.sortBy, reverseMode));
        }
        return latestVersionsOfAttachments;
    }

    public String[] getAttachmentDetails(Attachment attachment) {
        return new String[]{GeneralUtil.escapeXml(attachment.getFileName()), String.valueOf(attachment.getVersion())};
    }

    public long getUploadLimit() {
        return this.settingsManager.getGlobalSettings().getAttachmentMaxSize() / 1000000L;
    }

    public String getHighlightParameter() {
        StringBuffer highlightParameter = new StringBuffer();
        for (String highlightName : this.highlight) {
            highlightParameter.append("highlight=");
            highlightParameter.append(GeneralUtil.urlEncode(highlightName));
            highlightParameter.append("&");
        }
        return highlightParameter.toString();
    }

    public List getPreviousVersions(Attachment attachment) {
        List allVersions = this.attachmentManager.getAllVersions(attachment);
        allVersions.remove(0);
        return allVersions;
    }

    public int getMaxAttachments() {
        return this.settingsManager.getGlobalSettings().getMaxAttachmentsInUI();
    }

    public void setFileUploadManager(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }

    public List<String> getHighlight() {
        return this.highlight;
    }

    public void setHighlight(List<String> names) {
        this.highlight = names;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }
}

