/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.json.JSONAction;
import com.atlassian.confluence.json.JSONArray;
import com.atlassian.confluence.json.JSONException;
import com.atlassian.confluence.json.JSONObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.user.User;
import java.util.Collections;
import java.util.List;

public class ChildrenAction
extends AbstractPageAwareAction
implements SpaceAware,
JSONAction {
    private String node;
    private Space space;
    private PageManager pageManager;

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public List getPermittedChildren() {
        List children = null;
        if ("root".equals(this.node)) {
            children = this.getPermittedEntitiesOf(this.pageManager.getTopLevelPages(this.getSpace()));
        } else {
            AbstractPage page = this.getPage();
            if (page instanceof Page) {
                children = this.getPermittedEntitiesOf(((Page)page).getChildren());
            }
        }
        if (children != null) {
            Collections.sort(children, Page.pageComparator);
        }
        return children;
    }

    public String execute() throws Exception {
        return super.execute();
    }

    public void setNode(String node) {
        this.node = node;
    }

    public boolean isPageRequired() {
        return false;
    }

    public Space getSpace() {
        return this.space == null ? super.getSpace() : this.space;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public boolean isSpaceRequired() {
        return false;
    }

    public String getJSONString() {
        try {
            String contextPath = this.getBootstrapManager().getWebAppContextPath();
            User currentUser = AuthenticatedUserThreadLocal.getUser();
            JSONArray array = new JSONArray();
            List permittedChildren = this.getPermittedChildren();
            for (Object aPermittedChildren : permittedChildren) {
                String nodeClass;
                Page page = (Page)aPermittedChildren;
                String linkClass = page.isHomePage() ? "home-node" : (page.isRecentlyUpdatedFor(currentUser) ? "new-page-node" : "page-node");
                String string = nodeClass = this.getPermittedEntitiesOf(page.getChildren()).isEmpty() ? "" : "closed";
                if (!this.permissionManager.hasPermission(this.getRemoteUser(), Permission.EDIT, page)) {
                    nodeClass = nodeClass + " undraggable";
                }
                String href = contextPath + page.getUrlPath();
                array.put(new JSONObject().put("text", PlainTextToHtmlConverter.encodeHtmlEntities(page.getDisplayTitle())).put("pageId", String.valueOf(page.getId())).put("position", page.getPosition()).put("linkClass", linkClass).put("nodeClass", nodeClass).put("href", href));
            }
            return array.toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException("Can't construct JSON data");
        }
    }
}

