/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.actions.CommentAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.webwork.AbstractAwareInterceptor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;

public class CommentAwareInterceptor
extends AbstractAwareInterceptor {
    private CommentManager commentManager;
    private PermissionManager permissionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        UtilTimerStack.push((String)"CommentAwareInterceptor.intercept()");
        try {
            Action action = actionInvocation.getAction();
            if (action instanceof CommentAware) {
                CommentAware commentAware = (CommentAware)action;
                Comment comment = this.getComment();
                if (comment != null && this.getPermissionManager().hasPermission(this.getUser(), Permission.VIEW, comment)) {
                    commentAware.setComment(comment);
                }
            }
        }
        finally {
            UtilTimerStack.pop((String)"CommentAwareInterceptor.intercept()");
        }
        return actionInvocation.invoke();
    }

    private Comment getComment() {
        if (this.hasParameter("commentId")) {
            return this.getComment(this.getParameter("commentId"));
        }
        if (this.hasParameter("focusedCommentId")) {
            return this.getComment(this.getParameter("focusedCommentId"));
        }
        return null;
    }

    private Comment getComment(String commentId) {
        try {
            return this.getCommentManager().getComment(Long.parseLong(commentId));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private CommentManager getCommentManager() {
        if (this.commentManager == null && ContainerManager.isContainerSetup()) {
            this.commentManager = (CommentManager)ContainerManager.getComponent((String)"commentManager");
        }
        return this.commentManager;
    }

    private PermissionManager getPermissionManager() {
        if (this.permissionManager == null && ContainerManager.isContainerSetup()) {
            this.permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
        }
        return this.permissionManager;
    }
}

