/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.CreatePageAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.io.IOUtils;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

public class CopyPageAction
extends CreatePageAction {
    private long idOfPageToCopy;
    private Page pageToCopy;
    private AttachmentManager attachmentManager;

    public String doDefault() throws Exception {
        String titleOfCopy = "";
        if (!this.getPageToCopy().getTitle().startsWith(this.getText("copy.of"))) {
            titleOfCopy = titleOfCopy + this.getText("copy.of") + " ";
        }
        titleOfCopy = titleOfCopy + this.getPageToCopy().getTitle();
        this.setTitle(titleOfCopy);
        this.setContent(this.getPageToCopy().getContent());
        if (this.getPageToCopy().getParent() != null) {
            this.setParentPageString(this.getPageToCopy().getParent().getTitle());
        }
        String labels = "";
        Iterator iter = this.getPageToCopy().getLabels().iterator();
        while (iter.hasNext()) {
            Label l = (Label)iter.next();
            labels = labels + l.getName() + (iter.hasNext() ? ", " : "");
        }
        this.setLabelsString(labels);
        return super.doDefault();
    }

    public void validate() {
        super.validate();
        if (!this.permissionManager.hasCreatePermission(this.getRemoteUser(), this.getNewSpace(), Page.class)) {
            this.addFieldError("parentPageString", this.getText("copy.space.error.space.create.page.permission.denied"));
        }
    }

    public String doAdd() throws Exception {
        String copyPageResult = super.doAdd();
        if ("success".equals(copyPageResult)) {
            List<Attachment> attachments = this.attachmentManager.getLatestVersionsOfAttachments(this.getPageToCopy());
            for (Attachment attachment : attachments) {
                Attachment attachmentCopy = new Attachment();
                attachmentCopy.setFileName(attachment.getFileName());
                attachmentCopy.setFileSize(attachment.getFileSize());
                attachmentCopy.setContentType(attachment.getContentType());
                attachmentCopy.setComment(attachment.getComment());
                attachmentCopy.setAttachmentVersion(new Integer(1));
                attachmentCopy.setContent(this.getPage());
                InputStream data = this.attachmentManager.getAttachmentData(attachment);
                this.attachmentManager.saveAttachment(attachmentCopy, null, data);
                IOUtils.close(data);
            }
            return "success";
        }
        return copyPageResult;
    }

    public boolean isShowDraftMessage() {
        return false;
    }

    public Page getPageToCopy() {
        if (this.pageToCopy == null) {
            this.pageToCopy = this.pageManager.getPage(this.idOfPageToCopy);
        }
        return this.pageToCopy;
    }

    public boolean isPageRequired() {
        return false;
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        return this.pageToCopyIsNullOrPermitted();
    }

    private boolean pageToCopyIsNullOrPermitted() {
        return this.getPageToCopy() == null || this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, this.getPageToCopy().getLatestVersion());
    }

    public long getIdOfPageToCopy() {
        return this.idOfPageToCopy;
    }

    public void setIdOfPageToCopy(long idOfPageToCopy) {
        this.idOfPageToCopy = idOfPageToCopy;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

