/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractCreatePageAction;
import com.atlassian.confluence.pages.actions.ActionHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CreatePageAction
extends AbstractCreatePageAction {
    private String linkCreation = "";

    public void validate() {
        String parentPageTitle;
        if (this.titleIsSetToDefault("untitled.page.title")) {
            this.setTitle("");
        }
        super.validate();
        if (StringUtils.isNotEmpty((String)this.getTitle()) && (this.getPage() != null || this.pageManager.getPage(this.getSpaceKey(), this.getTitle()) != null)) {
            this.addFieldError("title", this.getText("page.title.exists.pagespecific", new String[]{this.getTitle(), this.getSpaceKey()}));
        }
        if (TextUtils.stringSet((String)this.getParentPageString()) && TextUtils.noNull((String)(parentPageTitle = ActionHelper.extractPageTitle(this.getParentPageString()))).toLowerCase().equals(this.getTitle().toLowerCase())) {
            this.addFieldError("parentPageString", this.getText("page.cant.be.parent.of.itself"));
        }
    }

    protected void createDraftIfItDoesNotExist() {
        this.draftManager.getOrCreate(AuthenticatedUserThreadLocal.getUsername(), "page", this.getSpaceKey());
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        return this.permissionManager.hasCreatePermission(this.getRemoteUser(), this.getNewSpace(), Page.class);
    }

    public void setLinkCreation(String linkCreation) {
        this.linkCreation = linkCreation;
    }

    public String getLinkCreation() {
        return this.linkCreation;
    }

    public void setEncodedTitle(String encodedTitle) {
        this.setTitle(GeneralUtil.base64Decode(encodedTitle));
    }

    public String doDefault() throws Exception {
        this.populateParentPageTitleField();
        if ((this.linkCreation.equalsIgnoreCase("yes") || this.linkCreation.equalsIgnoreCase("true")) && this.getPage() != null) {
            return "already-exists";
        }
        return super.doDefault();
    }

    protected void populateParentPageTitleField() {
        if (this.getFromPage() != null) {
            this.parentPageString = this.getFromPage().getOriginalVersionPage() != null ? this.getFromPage().getOriginalVersionPage().getTitle() : this.getFromPage().getTitle();
        }
    }

    public void createPage() throws IOException {
        super.createPage();
        this.assignParentPage((Page)this.getPage(), this.getParentPage());
    }

    protected AbstractPage getPageToCreate() {
        return new Page();
    }

    private void assignParentPage(Page page, Page parentPage) {
        if (parentPage != null) {
            parentPage.addChild(page);
        }
    }

    public Set getInheritedViewPermissions() {
        if (this.getParentPage() != null) {
            return this.contentPermissionManager.getViewContentPermissions(this.getParentPage());
        }
        return Collections.EMPTY_SET;
    }
}

