/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.AbstractDiffPagesAction;

public class DiffPagesByVersionAction
extends AbstractDiffPagesAction {
    private int originalVersion;
    private int revisedVersion;
    private AbstractPage revisedPage;

    public void validate() {
        super.validate();
        if (this.originalVersion < 1 || this.revisedVersion < 1) {
            this.addActionError(this.getText("error.must.specify.two.versions"));
        }
    }

    public void setOriginalVersion(int originalVersion) {
        this.originalVersion = originalVersion;
    }

    public void setRevisedVersion(int revisedVersion) {
        this.revisedVersion = revisedVersion;
    }

    public AbstractPage getOriginalPage() {
        if (this.originalPage == null && this.originalVersion != 0) {
            this.originalPage = (AbstractPage)this.pageManager.getOtherVersion(this.getPage(), this.originalVersion);
        }
        return this.originalPage;
    }

    public AbstractPage getRevisedPage() {
        if (this.revisedPage == null && this.revisedVersion != 0) {
            this.revisedPage = (AbstractPage)this.pageManager.getOtherVersion(this.getPage(), this.revisedVersion);
        }
        return this.revisedPage;
    }

    public void setSelectedPageVersions(String[] selectedPageVersions) {
        if (selectedPageVersions.length == 2) {
            int version1 = Integer.parseInt(selectedPageVersions[0]);
            int version2 = Integer.parseInt(selectedPageVersions[1]);
            this.setOriginalVersion(Math.min(version1, version2));
            this.setRevisedVersion(Math.max(version1, version2));
        }
    }
}

