/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.RandomGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;

public class DownloadAllAttachmentsOnPageAction
extends AbstractPageAwareAction {
    AttachmentManager attachmentManager;
    private static final String ZIP_FILE_PATTERN = "download{0}{1,time,HHmmss}";
    private String downloadPath;
    private File tempDirectoryForZipping;
    private String zipFilename;
    private GateKeeper gateKeeper;

    public String execute() throws Exception {
        List<Attachment> latestAttachments = this.attachmentManager.getLatestVersionsOfAttachments(this.getPage());
        for (Attachment attachment : latestAttachments) {
            InputStream inputStream = this.attachmentManager.getAttachmentData(attachment);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.getTempDirectoryForZipping(), attachment.getFileName()));
            FileUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        File zipFile = new File(this.getConfluenceTempDirectoryPath() + File.separator + this.getZipFilename() + ".zip");
        FileUtils.createZipFile((File)this.getTempDirectoryForZipping(), (File)zipFile);
        FileUtils.deleteDir((File)this.getTempDirectoryForZipping());
        this.downloadPath = this.prepareDownloadPath(zipFile.getPath());
        this.gateKeeper.addKey(this.downloadPath, this.getRemoteUser());
        return "success";
    }

    private File getTempDirectoryForZipping() throws IOException {
        if (this.tempDirectoryForZipping == null) {
            this.tempDirectoryForZipping = new File(this.getConfluenceTempDirectoryPath() + File.separator + this.getZipFilename());
            if (!this.tempDirectoryForZipping.exists()) {
                if (this.tempDirectoryForZipping.mkdirs()) {
                    return this.tempDirectoryForZipping;
                }
                throw new IOException("Could not create directory: " + this.tempDirectoryForZipping.getPath());
            }
        }
        return this.tempDirectoryForZipping;
    }

    private String getConfluenceTempDirectoryPath() {
        return this.getBootstrapManager().getFilePathProperty("webwork.multipart.saveDir");
    }

    private String getZipFilename() {
        if (this.zipFilename == null) {
            this.zipFilename = MessageFormat.format(ZIP_FILE_PATTERN, RandomGenerator.randomString((int)5), new Date());
        }
        return this.zipFilename;
    }

    public String prepareDownloadPath(String path) throws IOException {
        String homeDir = new File(this.getBootstrapManager().getConfluenceHome()).getCanonicalPath();
        String canonicalPath = new File(path).getCanonicalPath();
        int homeDirIndex = canonicalPath.indexOf(homeDir);
        if (homeDirIndex != -1) {
            path = canonicalPath.substring(homeDirIndex + homeDir.length() + 1);
        }
        return "/download/" + path.replaceAll("\\\\", "/");
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }
}

