/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.actions.AbstractEditPageAction;
import java.util.List;

public class EditBlogPostAction
extends AbstractEditPageAction {
    public void validate() {
        super.validate();
        BlogPost post = this.pageManager.getBlogPost(this.getSpaceKey(), this.getTitle(), BlogPost.toCalendar(this.getPostingDate()));
        if (post != null && this.isTitleModified()) {
            this.addFieldError("title", this.getText("news.title.exists"));
        }
    }

    public String doEdit() throws Exception {
        this.setTitle(this.getTitle().trim());
        String result = super.doEdit();
        if ("success".equals(result)) {
            if (this.isTitleModified()) {
                this.getPage().setTitle(this.getTitle());
            }
            return this.doSaveEditPageBean();
        }
        return result;
    }

    protected List getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        this.addPermissionTypeTo("EDITBLOG", permissionTypes);
        if (permissionTypes.contains("EDITSPACE")) {
            permissionTypes.remove("EDITSPACE");
        }
        return permissionTypes;
    }
}

