/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.pages.actions.ActionHelper;
import com.atlassian.confluence.pages.actions.beans.AttachmentBean;
import com.atlassian.confluence.pages.actions.beans.BootstrapAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.util.AttachFileHelper;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveAttachmentAction
extends AbstractPageAwareAction
implements BootstrapAware {
    private static final Logger log = Logger.getLogger(MoveAttachmentAction.class);
    private List availableSpaces;
    private String newFileName;
    private String newParentPage;
    private String newComment;
    private boolean updateLinks;
    private String newContentType;
    private static final Pattern DATE_PATH_PATTERN = Pattern.compile("/\\d{4}/\\d{2}/\\d{2}/.*");
    private AttachmentManager attachmentManager;
    private LinkManager linkManager;
    private PageManager pageManager;
    protected Collection<ContentEntityObject> suggestedContentToBeRefactored;
    private Attachment attachment;
    private final AttachmentBean attachmentBean = new AttachmentBean();
    private final AttachmentBean newAttachmentBean = new AttachmentBean();
    private String newPageTitle;
    private String newSpaceKey;
    private Space newSpace;

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setNewPageTitle(String newPageTitle) {
        this.newPageTitle = newPageTitle == null ? null : newPageTitle.trim();
    }

    public void setNewComment(String newComment) {
        this.newComment = newComment;
    }

    public void setNewContentType(String contentType) {
        this.newContentType = contentType;
    }

    public void setUpdateLinks(boolean updateLinks) {
        this.updateLinks = updateLinks;
    }

    public void setNewParentPage(String newParentPage) {
        this.newSpaceKey = ActionHelper.extractSpaceKey(newParentPage);
        this.newPageTitle = ActionHelper.extractPageTitle(newParentPage);
        this.newParentPage = newParentPage;
    }

    public void setNewFileName(String fileName) {
        this.newFileName = fileName;
    }

    @Override
    public void bootstrap() {
        if (StringUtils.isNotEmpty((String)this.newSpaceKey)) {
            this.newSpace = this.spaceManager.getSpace(this.newSpaceKey);
        }
        AbstractPage pageHoldingAttachment = this.getPage();
        this.attachment = this.attachmentBean.retrieveMatchingAttachment(pageHoldingAttachment, this.attachmentManager);
        Assert.notNull((Object)pageHoldingAttachment);
        if (this.newContentType == null) {
            this.newContentType = this.attachment.getContentType();
        }
        if (this.newComment == null) {
            this.newComment = this.attachment.getComment();
        }
        if (this.newFileName == null) {
            this.newFileName = this.attachmentBean.getFileName();
        }
        this.suggestedContentToBeRefactored = this.linkManager.getReferringContent(this.getPage());
        this.suggestedContentToBeRefactored.add(this.getPage());
    }

    public void validate() {
        boolean checkForClashes;
        super.validate();
        if (StringUtils.isEmpty((String)this.newFileName)) {
            this.addFieldError("rename", this.getText("fileName.required"));
        } else if (!AttachFileHelper.isValidFileName(this.newFileName)) {
            this.addFieldError("rename", this.getText("fileName.invalid", new Object[]{this.newFileName}));
        }
        AbstractPage destinationPage = this.getPageForAttachment();
        if (this.destinationPageChange()) {
            if (StringUtils.isEmpty((String)this.newPageTitle)) {
                this.addFieldError("newPageTitle", this.getText("page.title.empty"));
            } else if (this.isToPage()) {
                if (AbstractPage.hasInvalidTitleCharacters(this.newPageTitle)) {
                    this.addFieldError("move", this.getText("page.title.invalid"));
                } else if (destinationPage == null) {
                    this.addFieldError("move", this.getText("page.doesnot.exist"));
                }
            } else if (this.isToBlogPost()) {
                if (AbstractPage.hasInvalidTitleCharacters(this.getBlogPostTitleFromDatePath(this.newPageTitle))) {
                    this.addFieldError("move", this.getText("page.title.invalid"));
                } else if (destinationPage == null) {
                    this.addFieldError("move", this.getText("blog.info.insufficient"));
                }
            }
        }
        if (StringUtils.isNotEmpty((String)this.newComment) && this.newComment.length() > 255) {
            this.addFieldError("newComment", this.getText("comment.length.limit"));
        }
        boolean bl = checkForClashes = !this.destinationPageChange() || this.destinationPageChange() && destinationPage != null;
        if (checkForClashes && this.attachmentManager.getAttachment(destinationPage, this.newFileName) != null) {
            this.handleFilenameClash(destinationPage);
        }
        if (checkForClashes && !this.permissionManager.hasCreatePermission(this.getRemoteUser(), destinationPage, Attachment.class)) {
            this.addFieldError("move", this.getText("move.attachment.destination.permission.denied", new Object[]{GeneralUtil.htmlEncode(this.newSpace.getName())}));
        }
    }

    private void handleFilenameClash(AbstractPage destinationPage) {
        if (destinationPage == this.getPage() && !this.attachmentBean.getFileName().equals(this.newFileName)) {
            this.addFieldError("rename", this.getText("fileName.exists"));
        } else if (destinationPage != this.getPage()) {
            this.addFieldError("rename", this.getText("fileName.exists.destination.page"));
        }
    }

    @Override
    public boolean isPermitted() {
        boolean hasPermissionToViewAttachment = this.permissionManager.hasPermission(this.getRemoteUser(), Permission.EDIT, this.attachment);
        return super.isPermitted() && hasPermissionToViewAttachment;
    }

    public String execute() throws Exception {
        AbstractPage oldContainer;
        if (this.attachment.getComment() == null || !this.attachment.getComment().equals(this.newComment)) {
            this.attachment.setComment(this.newComment);
        }
        if (StringUtils.isNotBlank((String)this.newContentType)) {
            this.attachment.setContentType(this.newContentType);
        }
        try {
            oldContainer = (AbstractPage)this.attachment.getContent();
        }
        catch (ClassCastException e) {
            log.error((Object)"The original ContentEntityObject owning the attachment could not be cast to AbstractPage", (Throwable)e);
            this.addActionError(this.getText("error.reading.current.home"));
            return "error";
        }
        AbstractPage destinationPage = this.getPageForAttachment();
        if (this.updateLinks) {
            for (ContentEntityObject referringContent : this.suggestedContentToBeRefactored) {
                ContentEntityObject originalVersion = (ContentEntityObject)referringContent.clone();
                this.linkManager.renameOutgoingLinksToMovedAttachments(referringContent, this.attachmentBean.getFileName(), this.newFileName, oldContainer, destinationPage);
                if (referringContent.getContent().equals(originalVersion.getContent())) continue;
                this.pageManager.saveContentEntity(referringContent, originalVersion, null);
            }
        }
        this.attachmentManager.moveAttachment(this.attachment, this.newFileName, destinationPage);
        return "success";
    }

    public List getAvailableSpaces() {
        if (this.availableSpaces == null) {
            ArrayList<String> permissionTypes = new ArrayList<String>();
            permissionTypes.add("EDITSPACE");
            List spaces = this.spaceManager.getEditableSpacesByType(this.getRemoteUser(), SpaceType.GLOBAL);
            Iterator it = spaces.iterator();
            while (it.hasNext()) {
                Space space = (Space)it.next();
                if (this.hasPermissionForSpace(permissionTypes, space)) continue;
                it.remove();
            }
            this.availableSpaces = spaces;
        }
        return this.availableSpaces;
    }

    public String getNewFileName() {
        return this.newFileName;
    }

    public String getNewParentPage() {
        return this.newParentPage;
    }

    public boolean isUpdateLinks() {
        return this.updateLinks;
    }

    public String getNewComment() {
        return this.newComment;
    }

    public Collection<ContentEntityObject> getSuggestedContentToBeRefactored() {
        return this.suggestedContentToBeRefactored;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public String getNewContentType() {
        return this.newContentType;
    }

    public AttachmentBean getAttachmentBean() {
        return this.attachmentBean;
    }

    public AttachmentBean getNewAttachmentBean() {
        return this.newAttachmentBean;
    }

    private boolean isToBlogPost() {
        Matcher m = DATE_PATH_PATTERN.matcher(this.newPageTitle);
        return m.matches();
    }

    private boolean isToPage() {
        return !this.isToBlogPost();
    }

    private AbstractPage getPageForAttachment() {
        if (this.destinationPageChange()) {
            String spaceKeyToUse = this.newSpaceKey;
            if (StringUtils.isBlank((String)spaceKeyToUse)) {
                spaceKeyToUse = this.getPage().getSpaceKey();
            }
            if (this.isToBlogPost()) {
                return this.pageManager.getBlogPost(spaceKeyToUse, this.getBlogPostTitleFromDatePath(this.newPageTitle), this.getBlogPostCalendarFromDatePath(this.newPageTitle));
            }
            return this.pageManager.getPage(spaceKeyToUse, this.newPageTitle);
        }
        return this.getPage();
    }

    private boolean destinationPageChange() {
        return StringUtils.isNotEmpty((String)this.newParentPage);
    }

    private String getBlogPostTitleFromDatePath(String datePath) {
        String blogTitle = null;
        try {
            blogTitle = this.newPageTitle.split("/")[4];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error((Object)(datePath + " is not a valid blog date path containing a title; e.g. 2005/03/03/aBlogTitle"));
            return null;
        }
        return blogTitle;
    }

    private Calendar getBlogPostCalendarFromDatePath(String datePath) {
        String[] yearMonthDay = datePath.split("/");
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            year = Integer.parseInt(yearMonthDay[1]);
            month = Integer.parseInt(yearMonthDay[2]);
            day = Integer.parseInt(yearMonthDay[3]);
            if (month != 0) {
                --month;
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Unable to parse " + datePath + " for ints as /year/month/day/(ignored)"), (Throwable)e);
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(year, month, day);
        calendar.set(year, month, day);
        return calendar;
    }

    public void setFileName(String fileName) {
        this.attachmentBean.setFileName(fileName);
    }

    public void setVersion(int version) {
        this.attachmentBean.setVersion(version);
    }
}

