/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.pages.actions.PageNotPermittedAction;
import com.atlassian.confluence.pages.actions.beans.BootstrapAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.webwork.AbstractAwareInterceptor;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Category;

public class PageAwareInterceptor
extends AbstractAwareInterceptor {
    private Category log = Category.getInstance(PageAwareInterceptor.class);
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private SpaceManager spaceManager;
    private static final String POSTING_DAY_FORMAT = "yyyy/MM/dd";

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        UtilTimerStack.push((String)"PageAwareInterceptor.intercept()");
        try {
            Action action = actionInvocation.getAction();
            if (action instanceof PageAware) {
                Space space;
                PageAware pageAware = (PageAware)action;
                AbstractPage page = this.getPage();
                if (page != null && pageAware.isLatestVersionRequired()) {
                    page = (AbstractPage)page.getLatestVersion();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Set page on PageAware " + action.getClass().getName() + ": " + page));
                }
                if (page != null) {
                    pageAware.setPage(page);
                }
                if ((space = this.getSpace(page)) == null && TextUtils.stringSet((String)this.getSpaceKeyFromParameter()) || !this.getPermissionManager().hasPermission(this.getUser(), Permission.VIEW, space)) {
                    String string = this.getUser() == null ? "notpermitted" : "pagenotfound";
                    return string;
                }
                if (page == null && pageAware.isPageRequired()) {
                    String string = "pagenotfound";
                    return string;
                }
                if (action instanceof AbstractPageAwareAction && !(action instanceof PageNotPermittedAction)) {
                    AbstractPageAwareAction abstractPageAction = (AbstractPageAwareAction)action;
                    if (abstractPageAction instanceof BootstrapAware) {
                        ((BootstrapAware)action).bootstrap();
                    }
                    if (!abstractPageAction.isPermissionCheck() && !abstractPageAction.isPermitted()) {
                        if (page != null) {
                            String string = "pagenotpermitted";
                            return string;
                        }
                        String string = "notpermitted";
                        return string;
                    }
                }
            }
        }
        finally {
            UtilTimerStack.pop((String)"PageAwareInterceptor.intercept()");
        }
        return actionInvocation.invoke();
    }

    private Space getSpace(AbstractPage page) {
        if (page != null) {
            return ((AbstractPage)page.getLatestVersion()).getSpace();
        }
        String spaceKey = this.getSpaceKeyFromParameter();
        if (TextUtils.stringSet((String)spaceKey)) {
            return this.getSpaceManager().getSpace(spaceKey);
        }
        return null;
    }

    private AbstractPage getPage() {
        if (this.hasParameter("pageId")) {
            return this.getPageFromId();
        }
        if (this.hasParameter("spaceKey") && this.hasParameter("title")) {
            return this.getPageFromKeyAndTitle();
        }
        return null;
    }

    private AbstractPage getPageFromId() {
        try {
            AbstractPage page = this.getPageManager().getAbstractPage(Long.parseLong(this.getParameter("pageId")));
            return this.getPageVersion(page);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private AbstractPage getPageVersion(AbstractPage page) {
        if (page == null) {
            return null;
        }
        if (!this.hasParameter("pageVersion")) {
            return page;
        }
        try {
            return (AbstractPage)this.pageManager.getOtherVersion(page, Integer.parseInt(this.getParameter("pageVersion")));
        }
        catch (NumberFormatException e) {
            this.log.info((Object)("Could not parse version as integer: " + this.getParameter("pageVersion")));
            return page;
        }
    }

    private AbstractPage getPageFromKeyAndTitle() {
        String spaceKey = this.getSpaceKeyFromParameter();
        String title = this.getParameter("title");
        String postingDay = this.getParameter("postingDay");
        if (!AbstractPage.isValidPageTitle(title)) {
            return null;
        }
        if (!TextUtils.stringSet((String)postingDay)) {
            Page page = this.getPageManager().getPage(spaceKey, title, true);
            if (page == null) {
                return null;
            }
            if (this.hasParameter("pageVersion")) {
                return this.getPageVersion(page);
            }
            return page;
        }
        return this.getPageManager().getBlogPost(spaceKey, title, this.getPostingDayCalendar(postingDay), false);
    }

    private String getSpaceKeyFromParameter() {
        return this.getParameter("spaceKey");
    }

    private Calendar getPostingDayCalendar(String postingDay) {
        Date postingDate = this.getPostingDate(postingDay);
        if (postingDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(postingDate);
        return cal;
    }

    public Date getPostingDate(String postingDay) {
        Date postingDate = null;
        if (TextUtils.stringSet((String)postingDay)) {
            try {
                postingDate = new SimpleDateFormat(POSTING_DAY_FORMAT).parse(postingDay);
            }
            catch (ParseException e) {
                this.log.info((Object)("Invalid posting date supplied: " + postingDay));
            }
        }
        return postingDate;
    }

    private PageManager getPageManager() {
        if (this.pageManager == null) {
            this.pageManager = (PageManager)ContainerManager.getComponent((String)"pageManager");
        }
        return this.pageManager;
    }

    private PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            this.permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
        }
        return this.permissionManager;
    }

    private SpaceManager getSpaceManager() {
        if (this.spaceManager == null) {
            this.spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
        }
        return this.spaceManager;
    }
}

