/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.Spaced;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class PageNotFoundAction
extends ConfluenceActionSupport
implements Spaced {
    private String spaceKey;
    private String title;
    private List possibleAlternativesInSpace;
    private List possibleAlternativesElsewhere;
    private List possibleAlternativesInTrash;
    private List possibleAlternativesInSpaceSearch;
    private Space space;
    private SpaceManager spaceManager;
    private PageManager pageManager;

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public Space getSpace() {
        if (this.space == null && TextUtils.stringSet((String)this.spaceKey)) {
            this.space = this.spaceManager.getSpace(this.spaceKey);
        }
        return this.space;
    }

    public String execute() throws IOException {
        if (this.getPossibleAlternativesElsewhere().size() != 0 || this.getPossibleAlternativesInSpace().size() != 0 || this.getPossibleAlternativesInTrash().size() > 0 || this.getPossibleAlternativesInSpaceSearch().size() != 0) {
            ServletActionContext.getResponse().setStatus(404);
            return "success";
        }
        return "error";
    }

    public List getPossibleAlternativesElsewhere() {
        if (this.getTitle() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.possibleAlternativesElsewhere == null) {
            this.possibleAlternativesElsewhere = this.getPermittedEntitiesOf(this.pageManager.getPossibleRedirects(this.getTitle()));
            if (this.getSpace() != null) {
                Iterator it = this.possibleAlternativesElsewhere.iterator();
                while (it.hasNext()) {
                    AbstractPage page = (AbstractPage)it.next();
                    if (page == null || page.getSpace() == null || !page.getSpace().equals(this.getSpace())) continue;
                    it.remove();
                }
            }
        }
        return this.possibleAlternativesElsewhere;
    }

    public List getPossibleAlternativesInSpace() {
        if (this.getSpace() == null || this.getTitle() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.possibleAlternativesInSpace == null) {
            this.possibleAlternativesInSpace = this.getPermittedEntitiesOf(this.pageManager.getPossibleRedirectsForSpace(this.getSpace(), this.getTitle()));
        }
        return this.possibleAlternativesInSpace;
    }

    public List getPossibleAlternativesInTrash() {
        if (this.getSpace() == null || this.getTitle() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.possibleAlternativesInTrash == null) {
            this.possibleAlternativesInTrash = this.getPermittedEntitiesOf(this.pageManager.getPageInTrash(this.getSpaceKey(), this.getTitle()));
        }
        return this.possibleAlternativesInTrash;
    }

    public List getPossibleAlternativesInSpaceSearch() {
        if (this.getSpace() == null || this.getTitle() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.possibleAlternativesInSpaceSearch == null) {
            List possibleAlternativesInSpaceSearch = this.getPermittedEntitiesOf(this.pageManager.getPagesStartingWith(this.getSpace(), this.getTitle()));
            Collections.sort(possibleAlternativesInSpaceSearch, new PageByLength());
            this.possibleAlternativesInSpaceSearch = new ArrayList();
            int resultLimit = 5;
            for (int i = 0; i < possibleAlternativesInSpaceSearch.size() && i < resultLimit; ++i) {
                this.possibleAlternativesInSpaceSearch.add(i, possibleAlternativesInSpaceSearch.get(i));
            }
        }
        return this.possibleAlternativesInSpaceSearch;
    }

    private class PageByLength
    implements Comparator {
        private PageByLength() {
        }

        public int compare(Object obj1, Object obj2) {
            try {
                Page a = (Page)obj1;
                Page b = (Page)obj2;
                int comparison = a.getTitle().length() - b.getTitle().length();
                return comparison;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

