/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.content.service.CommentService;
import com.atlassian.confluence.content.service.comment.DeleteCommentCommand;
import com.atlassian.confluence.core.actions.ServiceBackedActionHelper;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;

public class RemoveCommentAction
extends AbstractPageAwareAction {
    private CommentService commentService;
    private DeleteCommentCommand deleteCommentCommand;
    private long commentId;
    private String confirm;

    public long getCommentId() {
        return this.commentId;
    }

    public void validate() {
        if (!this.getRemoveCommentCommand().isValid()) {
            new ServiceBackedActionHelper(this.getRemoveCommentCommand()).addValidationErrors(this);
        }
    }

    public void setCommentId(long commentId) {
        this.commentId = commentId;
    }

    public Comment getComment() {
        return this.getRemoveCommentCommand().getComment();
    }

    public String execute() throws Exception {
        if (this.confirm == null || !this.confirm.equals("yes") && !this.confirm.equals("OK")) {
            return "notconfirmed";
        }
        this.getRemoveCommentCommand().execute();
        return "success";
    }

    public boolean isPermitted() {
        return this.getRemoveCommentCommand().isAuthorized();
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    private DeleteCommentCommand getRemoveCommentCommand() {
        if (this.deleteCommentCommand == null) {
            this.deleteCommentCommand = this.commentService.newDeleteCommentCommand(this.commentId);
        }
        return this.deleteCommentCommand;
    }
}

