/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.opensymphony.util.TextUtils;

public class RestoreExistingTrashItemAction
extends AbstractSpaceAction
implements SpaceAdministrative {
    private PageManager pageManager;
    private ContentEntityManager contentEntityManager;
    protected long contentId;
    protected long existingContentId;
    private String newPageTitle;
    private String restoreAction;

    public String doDefault() throws Exception {
        this.setNewPageTitle(this.getContentEntityObject().getTitle());
        this.setRestoreAction("overwrite");
        return "input";
    }

    public void validate() {
        if ("rename".equals(this.getRestoreAction())) {
            if (!TextUtils.stringSet((String)this.getNewPageTitle())) {
                this.addActionError(this.getText("page.title.empty"));
            } else if (this.hasInvalidTitleCharacters(this.getNewPageTitle())) {
                this.addActionError(this.getText("page.title.invalid"));
            } else if (this.trashItemAlreadyExists((AbstractPage)this.getContentEntityObject()) && this.getContentEntityObject().getTitle().equals(this.getNewPageTitle())) {
                this.addActionError(this.getText("page.title.exists.specific", new Object[]{"'" + this.getNewPageTitle() + "'"}));
            }
        }
    }

    protected boolean hasInvalidTitleCharacters(String str) {
        return !AbstractPage.isValidPageTitle(str);
    }

    private AbstractPage getPage() {
        if (this.getContentEntityObject() instanceof AbstractPage) {
            return (AbstractPage)this.getContentEntityObject();
        }
        return null;
    }

    private boolean trashItemAlreadyExists(AbstractPage page) {
        return this.findExistingAbstractPage(page) != null;
    }

    private AbstractPage findExistingAbstractPage(AbstractPage page) {
        if (page instanceof Page) {
            return this.pageManager.getPage(page.getSpaceKey(), page.getTitle());
        }
        if (page instanceof BlogPost) {
            return this.pageManager.getBlogPost(page.getSpaceKey(), page.getTitle(), BlogPost.toCalendar(page.getCreationDate()));
        }
        return null;
    }

    public String execute() throws Exception {
        return this.getRestoreAction();
    }

    public String doOverwrite() {
        if (this.getExistingContentEntityObject() != null) {
            if (this.getExistingContentEntityObject() instanceof AbstractPage) {
                ((AbstractPage)this.getExistingContentEntityObject()).remove(this.pageManager);
            } else {
                this.contentEntityManager.removeContentEntity(this.getExistingContentEntityObject());
            }
        }
        this.restoreItem(this.getContentEntityObject());
        return "success";
    }

    public String doRenameAndRestore() {
        if (this.getPage() == null) {
            throw new UnsupportedOperationException("Can only rename Page and BlogPost entity objects.");
        }
        this.getPage().setContentStatus("current");
        this.pageManager.renamePage(this.getPage(), this.getNewPageTitle());
        return "success";
    }

    public boolean isRenamable() {
        return this.getContentEntityObject() instanceof AbstractPage;
    }

    private void restoreItem(ContentEntityObject ceo) {
        ceo.setContentStatus("current");
        this.contentEntityManager.saveContentEntity(ceo, null);
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public String getNewPageTitle() {
        return this.newPageTitle;
    }

    public void setNewPageTitle(String newPageTitle) {
        this.newPageTitle = newPageTitle;
    }

    public String getRestoreAction() {
        return this.restoreAction;
    }

    public void setRestoreAction(String restoreAction) {
        this.restoreAction = restoreAction;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public ContentEntityObject getContentEntityObject() {
        return this.contentEntityManager.getById(this.contentId);
    }

    public ContentEntityObject getExistingContentEntityObject() {
        return this.contentEntityManager.getById(this.existingContentId);
    }

    public long getContentId() {
        return this.contentId;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public long getExistingContentId() {
        return this.existingContentId;
    }

    public void setExistingContentId(long existingContentId) {
        this.existingContentId = existingContentId;
    }

    public String getType() {
        return this.getNiceContentType(this.getContentEntityObject());
    }
}

