/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.security.Permission;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TinyUrlAction
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(TinyUrlAction.class);
    private PageManager pageManager;
    private String urlPath;
    private String urlIdentifier;

    public void setUrlIdentifier(String urlIdentifier) {
        this.urlIdentifier = urlIdentifier;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public String execute() throws IOException {
        try {
            TinyUrl url = new TinyUrl(this.urlIdentifier);
            AbstractPage page = this.pageManager.getAbstractPage(url.getPageId());
            if (page == null) {
                ServletActionContext.getResponse().sendError(404, this.getText("tinyurl.not.found", new Object[]{this.urlIdentifier}));
                return "error";
            }
            this.urlPath = this.getUrlPath(page);
            return "success";
        }
        catch (Exception e) {
            log.error((Object)("Unable to retrieve page from TinyUrl: " + e.getMessage()), (Throwable)e);
            ServletActionContext.getResponse().sendError(404, this.getText("tinyurl.not.found", new Object[]{this.urlIdentifier}));
            return "error";
        }
    }

    private String getUrlPath(AbstractPage page) {
        if (this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, page)) {
            return page.getUrlPath();
        }
        return "/pages/viewpage.action?pageId=" + page.getId();
    }

    public String getUrlPath() {
        return this.urlPath;
    }
}

