/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions.beans;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.xwork.FileUploadUtils;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.xwork.ActionSupport;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ImageStorer {
    private final ActionSupport action;
    private final ContentEntityObject content;
    private final ThumbnailManager thumbnailManager;
    private Logger log = Logger.getLogger(ImageStorer.class);
    private String fileName = null;
    private boolean inited = false;

    public ImageStorer(ActionSupport action, ContentEntityObject content, ThumbnailManager thumbnailManager) {
        this.action = action;
        this.content = content;
        this.thumbnailManager = thumbnailManager;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void processMultipartRequest(MultiPartRequestWrapper multiPartRequest) {
        try {
            FileUploadUtils.checkMultiPartRequestForErrors((MultiPartRequestWrapper)multiPartRequest);
        }
        catch (FileUploadUtils.FileUploadException e) {
            this.action.addActionError(this.action.getText("multipart.request.error"));
            this.log.warn((Object)"An error occured uploading a file to the server.", (Throwable)e);
        }
        Enumeration fileParameterNames = multiPartRequest.getFileParameterNames();
        if (!fileParameterNames.hasMoreElements()) {
            this.action.addActionError(this.action.getText("null.file.error"));
            this.fileName = "";
        } else {
            String theFileName;
            String fileParameterName = TextUtils.noNull((String)((String)fileParameterNames.nextElement()));
            this.fileName = theFileName = multiPartRequest.getFileNames(fileParameterName)[0];
            if (theFileName == null) {
                this.action.addActionError(this.action.getText("null.file.error"));
            } else if (!(theFileName.toLowerCase().endsWith(".gif") || theFileName.toLowerCase().endsWith(".png") || theFileName.toLowerCase().endsWith(".jpg"))) {
                this.action.addActionError(theFileName + " " + this.action.getText("unsupported.file.error"));
            }
            Attachment attachment = this.content.getAttachmentNamed(theFileName);
            if (attachment != null && attachment.getFileName().equalsIgnoreCase(theFileName)) {
                this.thumbnailManager.getThumbnailFile(attachment).delete();
            }
        }
        this.inited = true;
    }
}

