/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao;

import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.persistence.dao.DraftDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionDraftDao
implements DraftDao {
    private final HttpSession session;

    public SessionDraftDao(HttpSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    @Override
    public void saveOrUpdate(Draft draft) {
        this.session.setAttribute(this.getSessionKey(draft.getPageId()), (Object)draft);
    }

    @Override
    public Draft getDraft(String pageId, String owner, String type) {
        return (Draft)this.session.getAttribute(this.getSessionKey(pageId));
    }

    @Override
    public Draft getDraft(long draftId) {
        throw new UnsupportedOperationException("the SessionDraftDao does not support Draft getDraft(long id)");
    }

    @Override
    public void remove(Draft draft) {
        this.session.removeAttribute(this.getSessionKey(draft.getPageId()));
    }

    @Override
    public void remove(long id) {
        throw new UnsupportedOperationException("the SessionDraftDao does not support void remove(long id)");
    }

    @Override
    public List<Draft> findByCreatorName(String creatorName) {
        return Collections.emptyList();
    }

    @Override
    public void updateSpaceKey(String newSpaceKey, String oldSpaceKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll() {
        Enumeration attributeNames = this.session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!attributeName.startsWith("confluence.pages.draft")) continue;
            this.session.removeAttribute(attributeName);
        }
    }

    @Override
    public List<Draft> findAll() {
        ArrayList<Draft> results = new ArrayList<Draft>();
        Enumeration attributeNames = this.session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!attributeName.startsWith("confluence.pages.draft")) continue;
            results.add((Draft)this.session.getAttribute(attributeName));
        }
        return results;
    }

    String getSessionKey(String contentId) {
        return "confluence.pages.draft" + contentId;
    }
}

