/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao.hibernate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.core.persistence.hibernate.VersionedHibernateObjectDao;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentDataNotFoundException;
import com.atlassian.confluence.pages.persistence.dao.AbstractAttachmentCopier;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDataDao;
import com.atlassian.confluence.pages.persistence.dao.CachingAttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.NonTransactionalAttachmentDataDao;
import com.atlassian.confluence.pages.persistence.dao.TransactionalAttachmentDataDao;
import com.atlassian.confluence.pages.persistence.dao.hibernate.NonTransactionalHibernateAttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.hibernate.TransactionalHibernateAttachmentDao;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ContentUtils;
import com.atlassian.confluence.util.io.IOUtils;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.joda.time.DateMidnight;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHibernateAttachmentDao
extends VersionedHibernateObjectDao
implements AttachmentDao,
CachingAttachmentDao {
    public static final long ONE_DAY = 86400000L;
    protected AttachmentDataDao dataDao;

    public AttachmentDataDao getDataDao() {
        return this.dataDao;
    }

    public static AttachmentDao getInstance(AttachmentDataDao attachmentDataDao) {
        if (attachmentDataDao instanceof TransactionalAttachmentDataDao) {
            TransactionalHibernateAttachmentDao transactionalDao = new TransactionalHibernateAttachmentDao();
            transactionalDao.setDataDao((TransactionalAttachmentDataDao)attachmentDataDao);
            return transactionalDao;
        }
        if (attachmentDataDao instanceof NonTransactionalAttachmentDataDao) {
            NonTransactionalHibernateAttachmentDao nonTransactionalDao = new NonTransactionalHibernateAttachmentDao();
            nonTransactionalDao.setDataDao((NonTransactionalAttachmentDataDao)attachmentDataDao);
            return nonTransactionalDao;
        }
        throw new IllegalArgumentException("Attachment data dao must implement a transactional marker interface");
    }

    public Class getPersistentClass() {
        return Attachment.class;
    }

    @Override
    public List<Attachment> getLatestVersionsOfAttachments(final ContentEntityObject ceo) {
        Assert.notNull((Object)ceo, (String)"Content entity object");
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (session.contains((Object)ceo)) {
                    Query q = session.createFilter((Object)ceo.getAttachments(), "where this.originalVersion is null");
                    q.setCacheable(true);
                    return q.list();
                }
                return ceo.getAttachments();
            }
        });
    }

    @Override
    public List findAllVersions(Attachment attachment) {
        List versionHistory = this.findNamedQueryStringParam("confluence.attachment_findVersionHistory", "originalVersionId", new Long(attachment.getId()));
        Collections.reverse(versionHistory);
        return versionHistory;
    }

    @Override
    public InputStream getAttachmentData(Attachment attachment) throws AttachmentDataNotFoundException {
        return this.dataDao.getDataForAttachment(attachment);
    }

    @Override
    public List getAttachmentByQuery(final ListQuery listQuery, final int firstResult) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List spaceIds = ContentUtils.getEntityObjectsIds(listQuery.getSpaceList());
                Date date = AbstractHibernateAttachmentDao.this.getTimeSpan(listQuery.getTimeSpan());
                boolean labelQuery = !listQuery.getLabelList().isEmpty();
                String queryString = "select {attachments.*} from ATTACHMENTS {attachments}, CONTENT c ";
                queryString = labelQuery ? queryString + "CONTENT_LABEL lc, LABEL l where c.CONTENTID = lc.CONTENTID and lc.LABELID = l.LABELID and l.name in (:labels) and " : queryString + "where ";
                queryString = queryString + " {attachments}.PAGEID = c.CONTENTID and c.SPACEID in (:spaceIds)and {attachments}.PREVVER is null and {attachments}.LASTMODDATE > :startDate and c.CONTENTTYPE != 'MAIL' order by {attachments}.LASTMODDATE desc";
                Query query = session.createSQLQuery(queryString, "attachments", Attachment.class);
                query.setParameterList("spaceIds", (Collection)spaceIds);
                if (labelQuery) {
                    query.setParameterList("labels", (Collection)listQuery.getLabelList());
                }
                query.setParameter("startDate", (Object)new Timestamp(date.getTime()));
                query.setFirstResult(firstResult);
                if (listQuery.getMaxResults() > 0) {
                    query.setMaxResults(listQuery.getMaxResults());
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)query, (SessionFactory)AbstractHibernateAttachmentDao.this.getSessionFactory());
                return query.list();
            }
        });
    }

    private Date getTimeSpan(float timeSpan) {
        long finalTimeSpan = (long)(8.64E7 * (double)timeSpan);
        Date currentDate = new Date();
        long fromDate = currentDate.getTime() - finalTimeSpan;
        DateMidnight midnightDate = new DateMidnight(fromDate);
        return midnightDate.toDate();
    }

    @Override
    public void saveNewAttachment(Attachment attachment, InputStream attachmentData) {
        this.save(attachment);
        this.dataDao.saveDataForAttachment(attachment, attachmentData);
    }

    @Override
    public void saveNewAttachmentVersion(Attachment attachment, Attachment previousVersion, InputStream attachmentData) {
        if (previousVersion == null) {
            this.saveNewAttachment(attachment, attachmentData);
        }
        attachment.setCreatorName(AuthenticatedUserThreadLocal.getUsername());
        attachment.setCreationDate(new Date());
        this.save(attachment, previousVersion);
        this.dataDao.saveDataForAttachmentVersion(attachment, previousVersion, attachmentData);
    }

    @Override
    public void moveAttachment(Attachment latestVersion, Attachment oldAttachment, ContentEntityObject newContent) {
        if (!latestVersion.isLatestVersion()) {
            throw new IllegalArgumentException("The attachment to be moved must be the latest version.");
        }
        List allAttachmentVersions = this.findAllVersions(latestVersion);
        for (Attachment attachment : allAttachmentVersions) {
            this.save(attachment);
        }
        this.dataDao.moveAttachment(latestVersion, oldAttachment, newContent);
    }

    protected void removeAttachment(Attachment attachment, ContentEntityObject content) {
        content.removeAttachment(attachment);
        this.remove(attachment);
    }

    @Override
    public AttachmentDao.AttachmentMigrator getMigrator(AttachmentDao destinationDao) {
        if (this.equals(destinationDao)) {
            throw new IllegalArgumentException("Source and destination attachment dao must not be the same instance for migration");
        }
        if (!(destinationDao instanceof AbstractHibernateAttachmentDao)) {
            throw new IllegalArgumentException("Source and destination AttachmentDaos must be of type '" + AbstractHibernateAttachmentDao.class + "'.");
        }
        return new IntraHibernateAttachmentMigrator((AbstractHibernateAttachmentDao)destinationDao);
    }

    @Override
    public AttachmentDao.AttachmentCopier getCopier(AttachmentDao destinationDao) {
        if (this.equals(destinationDao)) {
            throw new IllegalArgumentException("Source and destination attachment dao must not be the same instance for copying");
        }
        if (!(destinationDao instanceof AbstractHibernateAttachmentDao)) {
            throw new IllegalArgumentException("Source and destination AttachmentDaos must be of type '" + AbstractHibernateAttachmentDao.class + "'.");
        }
        return new IntraHibernateAttachmentCopier((AbstractHibernateAttachmentDao)destinationDao);
    }

    @Override
    public void prepareForMigrationTo() {
        this.getDataDao().prepareForMigrationTo();
        int numberDeleted = this.clearAttachmentTable();
        if (log.isInfoEnabled()) {
            log.info((Object)(numberDeleted + " records were deleted from the Attachment table to prepare for a migration to this data store."));
        }
    }

    @Override
    public void afterMigrationFrom() {
        this.getDataDao().afterMigrationFrom();
        int count = 0;
        Iterator latestAttachments = this.findLatestVersionsIterator();
        while (latestAttachments.hasNext()) {
            Attachment attachment = (Attachment)latestAttachments.next();
            for (Attachment previousVersion : this.findAllVersions(attachment)) {
                ContentEntityObject ceo = previousVersion.getContent();
                if (ceo == null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Attachment '" + previousVersion + "' doesn't have a ContentEntityObject. Weird."));
                    }
                    this.remove(previousVersion);
                    continue;
                }
                this.removeAttachment(previousVersion, ceo);
            }
            ++count;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(count + " records were deleted from the Attachment table to complete a migration from this data store."));
        }
    }

    private int clearAttachmentTable() {
        try {
            return this.getSession().delete("from Attachment");
        }
        catch (HibernateException e) {
            throw new RuntimeException("There was a problem removing all records in the Attachment table while performing a migration task.", e);
        }
    }

    @Override
    public void replaceAttachmentData(Attachment attachment, InputStream attachmentData) {
        this.dataDao.replaceDataForAttachment(attachment, attachmentData);
    }

    @Override
    public void flush() {
        try {
            this.getSession().flush();
        }
        catch (HibernateException e) {
            throw new RuntimeException("There was a problem flushing the Hibernate session.", e);
        }
    }

    public class IntraHibernateAttachmentMigrator
    extends IntraHibernateAttachmentCopier
    implements AttachmentDao.AttachmentMigrator {
        protected IntraHibernateAttachmentMigrator(AbstractHibernateAttachmentDao destinationDao) {
            super(destinationDao);
        }

        public void migrate() {
            this.log.info((Object)"Performing pre-migration tasks.");
            this.destinationDao.getDataDao().prepareForMigrationTo();
            super.copy();
            this.log.info((Object)"Performing post-migration tasks.");
            AbstractHibernateAttachmentDao.this.getDataDao().afterMigrationFrom();
            this.log.info((Object)"Flushing the DAOs (if necessary).");
            AbstractHibernateAttachmentDao.this.flush();
            this.flushDaoIfNecessary(this.destinationDao);
        }

        private void flushDaoIfNecessary(AttachmentDao attachmentDao) {
            if (!(attachmentDao instanceof CachingAttachmentDao)) {
                return;
            }
            ((CachingAttachmentDao)((Object)attachmentDao)).flush();
        }
    }

    public class IntraHibernateAttachmentCopier
    extends AbstractAttachmentCopier
    implements AttachmentDao.AttachmentCopier {
        protected Category log = Category.getInstance(IntraHibernateAttachmentCopier.class);
        protected AbstractHibernateAttachmentDao destinationDao;

        protected IntraHibernateAttachmentCopier(AbstractHibernateAttachmentDao destinationDao) {
            this.destinationDao = destinationDao;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy() {
            AttachmentDataDao destinationDataDao = this.destinationDao.getDataDao();
            AttachmentDataDao sourceDataDao = AbstractHibernateAttachmentDao.this.getDataDao();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Beginning copy from '" + sourceDataDao + "' to '" + destinationDataDao + "'"));
            }
            if (this.progress != null) {
                this.progress.setStatus("Finding Attachments");
            }
            int totalAttachments = (int)AbstractHibernateAttachmentDao.this.findLatestVersionsCount();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Found " + totalAttachments + " to copy"));
            }
            Iterator attachmentsIter = AbstractHibernateAttachmentDao.this.findLatestVersionsIterator();
            if (this.progress != null) {
                this.progress.setTotalObjects(totalAttachments);
                this.progress.setStatus("Copying attachments");
            }
            int currentAttachmentIndex = 0;
            while (attachmentsIter.hasNext()) {
                Attachment attachment = (Attachment)attachmentsIter.next();
                if (attachment.getContent() == null) {
                    this.log.error((Object)("Attachment '" + attachment + "' does not have a content object. Skipping."));
                    ++currentAttachmentIndex;
                    continue;
                }
                if (!this.isContentSpaceIncluded(attachment.getContent())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Skipping attachment '" + attachment + "' since its parent content '" + attachment.getContent() + "' is not in the included Space list."));
                    }
                    ++currentAttachmentIndex;
                    continue;
                }
                if (this.isContentExcluded(attachment.getContent())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Skipping attachment '" + attachment + "' since its parent content '" + attachment.getContent() + "' is in the exclusion list."));
                    }
                    ++currentAttachmentIndex;
                    continue;
                }
                List allAttachmentVersions = AbstractHibernateAttachmentDao.this.findAllVersions(attachment);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Copying attachment '" + attachment + "' and " + (allAttachmentVersions.size() - 1) + " previous versions."));
                }
                for (Attachment attachmentVersion : allAttachmentVersions) {
                    InputStream attachmentData = null;
                    try {
                        attachmentData = sourceDataDao.getDataForAttachment(attachmentVersion);
                        destinationDataDao.saveDataForAttachment(attachmentVersion, attachmentData);
                    }
                    catch (AttachmentDataNotFoundException e) {
                        this.log.error((Object)("There was a problem retrieving attachment '" + attachment + "' from the data store. Skipping."), (Throwable)e);
                    }
                    finally {
                        IOUtils.close(attachmentData);
                    }
                }
                if (this.progress == null) continue;
                this.progress.setCurrentCount(++currentAttachmentIndex);
                this.progress.setStatus("Copied " + currentAttachmentIndex + " out of " + totalAttachments + " attachments.");
            }
            this.log.info((Object)"Copy completed.");
            if (this.progress != null) {
                this.progress.setCurrentCount(totalAttachments);
                this.progress.setStatus("Completed - " + totalAttachments + " attachments transferred.");
            }
        }
    }
}

