/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao.hibernate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentData;
import com.atlassian.confluence.pages.AttachmentDataNotFoundException;
import com.atlassian.confluence.pages.persistence.dao.TransactionalAttachmentDataDao;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.hibernate.HibernateObjectDao;
import java.io.InputStream;
import java.util.List;
import net.sf.hibernate.HibernateException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class HibernateAttachmentDataDao
extends HibernateObjectDao
implements TransactionalAttachmentDataDao {
    public List findAll() {
        throw new UnsupportedOperationException("Retrieving all attachment data is not supported");
    }

    public List findAllSorted(String s) {
        throw new UnsupportedOperationException("Retrieving all attachment data is not supported");
    }

    public void save(EntityObject objectToSave) {
        super.save(objectToSave);
        try {
            this.getSession().flush();
            this.getSession().evict((Object)objectToSave);
        }
        catch (HibernateException e) {
            throw new RuntimeException("There was a problem evicting or flushing an AttachmentData object: ", e);
        }
    }

    public Class getPersistentClass() {
        return AttachmentData.class;
    }

    protected AttachmentData getAttachmentDataForAttachment(Attachment attachment) throws AttachmentDataNotFoundException {
        List dataObjects = this.getHibernateTemplate().findByNamedQueryAndNamedParam("confluence.ad_findAttachmentDataByAttachment", new String[]{"attachment", "version"}, new Object[]{attachment, new Integer(attachment.getVersion())});
        if (dataObjects.size() == 0) {
            throw new AttachmentDataNotFoundException("No AttachmentData object was returned when it was expected for attachment: " + attachment);
        }
        if (dataObjects.size() > 1) {
            throw new IncorrectResultSizeDataAccessException("Multiple AttachmentData objects were returned when only one was expected for attachment: " + attachment, 1, dataObjects.size());
        }
        return (AttachmentData)dataObjects.get(0);
    }

    public InputStream getDataForAttachment(Attachment attachment) throws AttachmentDataNotFoundException {
        if (attachment == null) {
            throw new IllegalArgumentException("Attachment must be non-null");
        }
        AttachmentData attachmentData = this.getAttachmentDataForAttachment(attachment);
        InputStream result = attachmentData.getData();
        this.getHibernateTemplate().evict((Object)attachmentData);
        return result;
    }

    public void removeDataForAttachment(Attachment attachment, ContentEntityObject originalContent) {
        if (attachment == null) {
            throw new IllegalArgumentException("Attachment must be non-null");
        }
        if (originalContent == null) {
            throw new IllegalArgumentException("Original content must be non-null");
        }
        if (!attachment.isLatestVersion()) {
            throw new IllegalArgumentException("Attachment must be latest version");
        }
        this.removeData(attachment);
    }

    private void removeData(Attachment previousVersion) {
        try {
            AttachmentData data = this.getAttachmentDataForAttachment(previousVersion);
            data.setAttachment(null);
            this.remove(data);
        }
        catch (AttachmentDataNotFoundException e) {
            log.error((Object)("Data not found while removing attachment '" + previousVersion + "'"), (Throwable)e);
        }
    }

    public void saveDataForAttachment(Attachment attachment, InputStream data) {
        AttachmentData attachmentData = new AttachmentData();
        attachmentData.setAttachment(attachment);
        attachmentData.setVersion(attachment.getVersion());
        attachmentData.setData(data);
        this.save(attachmentData);
    }

    public void saveDataForAttachmentVersion(Attachment attachment, Attachment previousVersion, InputStream data) {
        AttachmentData previousAttachmentData;
        Attachment previousAttachment = new Attachment();
        previousAttachment.setId(attachment.getId());
        previousAttachment.setVersion(previousVersion.getVersion());
        try {
            previousAttachmentData = this.getAttachmentDataForAttachment(previousAttachment);
        }
        catch (AttachmentDataNotFoundException e) {
            throw new RuntimeException("There was a problem retrieving the previous version of the Attachment data for Attachment '" + previousAttachment + "'.", e);
        }
        previousAttachmentData.setAttachment(previousVersion);
        previousAttachmentData.setVersion(previousVersion.getVersion());
        this.save(previousAttachmentData);
        AttachmentData newAttachmentData = new AttachmentData();
        newAttachmentData.setAttachment(attachment);
        newAttachmentData.setVersion(attachment.getVersion());
        newAttachmentData.setData(data);
        this.save(newAttachmentData);
    }

    public void replaceDataForAttachment(Attachment attachment, InputStream data) {
        AttachmentData attachmentData = null;
        try {
            attachmentData = this.getAttachmentDataForAttachment(attachment);
        }
        catch (AttachmentDataNotFoundException e) {
            // empty catch block
        }
        if (attachmentData == null) {
            this.saveDataForAttachment(attachment, data);
        } else {
            attachmentData.setData(data);
            this.save(attachmentData);
        }
    }

    public void moveAttachment(Attachment attachment, Attachment oldAttachment, ContentEntityObject newContent) {
    }

    public void prepareForMigrationTo() {
        int numberDeleted = this.clearAttachmentDataTable();
        if (log.isInfoEnabled()) {
            log.info((Object)(numberDeleted + " records were deleted from the AttachmentData table to prepare for a migration to this data store."));
        }
    }

    public void afterMigrationFrom() {
        int numberDeleted = this.clearAttachmentDataTable();
        if (log.isInfoEnabled()) {
            log.info((Object)(numberDeleted + " records were deleted from the AttachmentData table to complete a migration from this data store."));
        }
    }

    private int clearAttachmentDataTable() {
        try {
            return this.getSession().delete("from AttachmentData");
        }
        catch (HibernateException e) {
            throw new RuntimeException("There was a problem removing all records in the AttachmentData table, while performing a migration task.", e);
        }
    }
}

