/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.persistence.dao.CommentDao;
import java.util.Iterator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateCommentDao
extends ConfluenceHibernateObjectDao
implements CommentDao {
    public Class getPersistentClass() {
        return Comment.class;
    }

    public Comment getById(long id) {
        return (Comment)this.getByClassId(id);
    }

    public Iterator getRecentlyUpdatedComments(final long spaceId, final int maxResults) {
        return (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.content_findRecentlyModifiedCommentsBySpace");
                queryObject.setParameter("spaceId", (Object)new Long(spaceId));
                queryObject.setCacheable(true);
                if (maxResults > 0) {
                    queryObject.setMaxResults(maxResults);
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateCommentDao.this.getSessionFactory());
                return queryObject.list().iterator();
            }
        });
    }
}

