/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao.hibernate;

import com.atlassian.cache.Cache;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.confluence.cache.CacheManagerKeys;
import com.atlassian.confluence.core.persistence.hibernate.ContentEntityObjectHibernateDao;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.persistence.dao.LinkDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.persistence.dao.PageDao;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.core.exception.InfrastructureException;
import com.opensymphony.util.TextUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.FetchMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernatePageDao
extends ContentEntityObjectHibernateDao
implements PageDao {
    private boolean caching = true;
    private LinkDao linkDao;
    private HibernateConfig hibernateConfig;

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public void setLinkDao(LinkDao linkDao) {
        this.linkDao = linkDao;
    }

    public Page getPageById(long id) {
        EntityObject o = this.getByClassId(id);
        if (!(o instanceof Page)) {
            return null;
        }
        return (Page)o;
    }

    public Page getPage(String spaceKey, String pageTitle) {
        return this.getPage(spaceKey, pageTitle, false);
    }

    public Page getPage(String spaceKey, String pageTitle, boolean eagerLoadComments) {
        String theQueryToUse;
        List pages;
        Page page;
        if (spaceKey == null || pageTitle == null) {
            return null;
        }
        String key = this.getPageTitleToPageIdCacheKey(spaceKey, pageTitle);
        Long pageId = this.getCachedPageIdForPageTitle(key);
        if (pageId != null) {
            Page page2 = this.getPageById(pageId);
            if (page2 != null && page2.getTitle().equals(pageTitle) && page2.getSpace().getKey().equals(spaceKey) && page2.isCurrent()) {
                return page2;
            }
            try {
                this.removeCachedPageIdForPageTitle(key);
            }
            catch (Exception e) {
                log.error((Object)("Unable to removed cached page id for key [" + key + "]"), (Throwable)e);
            }
        }
        if ((page = (pages = this.findNamedQueryStringParams(theQueryToUse = eagerLoadComments ? "confluence.page_findLatestBySpaceKeyTitleOptimisedForComments" : "confluence.page_findLatestBySpaceKeyTitle", "spaceKey", spaceKey.toLowerCase(), "pageTitle", GeneralUtil.specialToLowerCase(pageTitle), true)).size() == 1 ? (Page)pages.get(0) : this.getFirstPage(pages)) != null && this.caching) {
            this.getCache().put((Object)key, (Object)new Long(page.getId()));
        }
        return page;
    }

    public List getPages(final Space space, final boolean currenOnly) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (space == null) {
                    return Collections.EMPTY_LIST;
                }
                Query queryObject = currenOnly ? session.getNamedQuery("confluence.page_findCurrentPagesForSpace") : session.getNamedQuery("confluence.page_findPagesForSpace");
                queryObject.setParameter("spaceid", (Object)new Long(space.getId()));
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernatePageDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    public List getPagesStartingWith(final Space space, final String s) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (space == null) {
                    return Collections.EMPTY_LIST;
                }
                Query queryObject = session.getNamedQuery("confluence.page_findPagesStartingWithForSpace");
                queryObject.setParameter("spaceid", (Object)new Long(space.getId()));
                queryObject.setParameter("string", (Object)GeneralUtil.specialToLowerCase(s).concat("%"));
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernatePageDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    private Page getFirstPage(List pages) {
        Page firstPage = null;
        for (Page page : pages) {
            if (firstPage != null && firstPage.getId() <= page.getId()) continue;
            firstPage = page;
        }
        return firstPage;
    }

    private void removeCachedPageIdForPageTitle(String key) throws Exception {
        if (!this.caching) {
            return;
        }
        this.getCache().remove((Object)key);
    }

    private Long getCachedPageIdForPageTitle(String key) {
        if (!this.caching) {
            return null;
        }
        try {
            Object value = this.getCache().get((Object)key);
            if (value != null) {
                return (Long)value;
            }
            return null;
        }
        catch (InfrastructureException e) {
            log.error((Object)"Error while trying to fetch cached permission check result from to the cache!", (Throwable)e);
            return null;
        }
    }

    private String getPageTitleToPageIdCacheKey(String spaceKey, String pageTitle) {
        return spaceKey + pageTitle;
    }

    public List getRecentlyAddedPages(int maxCount, String spaceKey) {
        if (spaceKey == null) {
            return this.findNamedQuery("confluence.page_findRecentlyAddedPages", false, maxCount);
        }
        return this.findNamedQueryStringParam("confluence.page_findRecentlyAddedPagesForSpace", "spaceKey", spaceKey.toLowerCase(), false, maxCount);
    }

    public List getRecentlyUpdatedPages(int maxCount, String spaceKey) {
        if (spaceKey == null) {
            return this.findNamedQuery("confluence.page_findRecentlyUpdatedPages", false, maxCount);
        }
        return this.findNamedQueryStringParam("confluence.page_findRecentlyUpdatedPagesForSpace", "spaceKey", spaceKey.toLowerCase(), false, maxCount);
    }

    public List getOrphanedPages(String spaceKey) {
        if (this.hibernateConfig.isMySql()) {
            return this.mySqlGetOrphanedPages(spaceKey);
        }
        if (spaceKey == null) {
            return this.findNamedQuery("confluence.page_findOrphanedPages");
        }
        return this.findNamedQueryStringParam("confluence.page_findOrphanedPagesForSpace", "spaceKey", spaceKey.toLowerCase());
    }

    private List mySqlGetOrphanedPages(String spaceKey) {
        List pages = this.getAllPagesForSpace(spaceKey);
        Iterator it = pages.iterator();
        while (it.hasNext()) {
            if (this.pageIsOrphan((Page)it.next())) continue;
            it.remove();
        }
        return pages;
    }

    private boolean pageIsOrphan(Page page) {
        List incomingLinks = this.linkDao.getLinksTo(page);
        return page.getParent() == null && (incomingLinks.isEmpty() || this.onlyContainsLinksToSelf(page, incomingLinks));
    }

    private boolean onlyContainsLinksToSelf(Page page, List incomingLinks) {
        String key = page.getSpace().getKey();
        String title = page.getTitle();
        boolean result = true;
        for (OutgoingLink link : incomingLinks) {
            if (link.getSourceContent().getType().equals("page") && link.getSourceContent().getTitle().equalsIgnoreCase(title) && ((Page)link.getSourceContent()).getSpace().getKey().equalsIgnoreCase(key)) continue;
            result = false;
        }
        return result;
    }

    private List getAllPagesForSpace(String spaceKey) {
        if (spaceKey == null) {
            return this.findNamedQuery("confluence.page_findRecentlyUpdatedPages");
        }
        return this.findNamedQueryStringParam("confluence.page_findRecentlyUpdatedPagesForSpace", "spaceKey", spaceKey.toLowerCase());
    }

    public List getUndefinedPages(String spaceKey) {
        if (this.hibernateConfig.isMySql()) {
            return this.mySqlGetUndefinedPages(spaceKey);
        }
        if (spaceKey == null) {
            return this.findNamedQuery("confluence.page_findUndefinedPages");
        }
        return this.findNamedQueryStringParam("confluence.page_findUndefinedPagesForSpace", "spaceKey", spaceKey.toLowerCase());
    }

    public List getPermissionPages(final Space space) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                List results = session.createCriteria(Page.class).add((Criterion)Expression.eq((String)"space", (Object)space)).setFetchMode("permissions", FetchMode.EAGER).list();
                return new ArrayList(new HashSet(results));
            }
        });
    }

    private List mySqlGetUndefinedPages(String spaceKey) {
        ArrayList<OutgoingLink> result = new ArrayList<OutgoingLink>();
        List links = this.linkDao.findByDestinationSpaceKey(spaceKey);
        for (OutgoingLink link : links) {
            if (link.getSourceContent() == null || !"current".equals(link.getSourceContent().getContentStatus()) || this.getPage(link.getDestinationSpaceKey(), link.getDestinationPageTitle()) != null || TextUtils.noNull((String)link.getDestinationPageTitle()).indexOf("@") != -1) continue;
            result.add(link);
        }
        return result;
    }

    public int getAuthoredPagesCountByUser(String username) {
        Object result = this.findSingleObject(this.findNamedQueryStringParam("confluence.page_findAuthoredPagesCountByUser", "creatorName", GeneralUtil.specialToLowerCase(username)));
        return (Integer)result;
    }

    public List getRecentlyAuthoredPagesByUser(String username, int maxCount) {
        return this.findNamedQueryStringParam("confluence.page_findRecentlyAuthoredPagesByUser", "userName", GeneralUtil.specialToLowerCase(username), false, maxCount);
    }

    public List getPagesCreatedOrUpdatedSinceDate(Date previousLoginDate) {
        if (previousLoginDate == null) {
            previousLoginDate = new Date();
        }
        return this.findNamedQueryStringParam("confluence.page_findPagesCreatedOrUpdatedSinceDate", "date", previousLoginDate, false);
    }

    public void remove(EntityObject objectToRemove) {
        AbstractPage page = (AbstractPage)objectToRemove;
        if (page.getSpace() != null) {
            this.removeFromPageKeyCache(page.getSpace().getKey(), page.getTitle());
        }
        super.remove(objectToRemove);
    }

    public Class getPersistentClass() {
        return Page.class;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public void removeFromPageKeyCache(String spaceKey, String pageTitle) {
        String key = this.getPageTitleToPageIdCacheKey(spaceKey, pageTitle);
        if (this.getCachedPageIdForPageTitle(key) != null) {
            try {
                this.getCache().remove((Object)key);
            }
            catch (Exception e) {
                log.error((Object)("Unable to remove pagekey [" + key + " from cache"), (Throwable)e);
            }
        }
    }

    private Cache getCache() {
        return this.cacheFactory.getCache(CacheManagerKeys.CACHE_KEY_PAGE_TITLE_TO_PAGEID);
    }

    public List findPagesWithHistoricalTitle(String pageTitle) {
        List ids = this.findNamedQueryStringParam("confluence.page_findPagesWithHistoricalTitle", "pageTitle", GeneralUtil.specialToLowerCase(pageTitle), true);
        ArrayList<Page> pages = new ArrayList<Page>(ids.size());
        for (Long id : ids) {
            pages.add(this.getPageById(id));
        }
        return pages;
    }

    public List getPageInTrash(String spaceKey, String title) {
        if (spaceKey == null || title == null) {
            return null;
        }
        return this.findNamedQueryStringParams("confluence.page_findTrashedPageBySpaceKeyTitle", "spaceKey", spaceKey.toLowerCase(), "pageTitle", GeneralUtil.specialToLowerCase(title), true);
    }

    public List getDescendents(final Page page) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createSQLQuery("select {confpage.*} from CONFANCESTORS ancestors, CONTENT {confpage} where {confpage}.CONTENTID = ancestors.DESCENDENTID and ancestors.ANCESTORID = ?", "confpage", Page.class);
                query.setLong(0, page.getId());
                return query.list();
            }
        });
    }

    public List getDescendentIds(final Page page) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                ArrayList<Long> descendentIds = new ArrayList<Long>();
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    Connection c = session.connection();
                    String mysql = "select DESCENDENTID from CONFANCESTORS where ANCESTORID = " + page.getId();
                    ps = c.prepareStatement(mysql);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        descendentIds.add(new Long(rs.getLong(1)));
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(ps);
                    throw throwable;
                }
                JDBCUtils.close((ResultSet)rs);
                JDBCUtils.close((Statement)ps);
                return descendentIds;
            }
        });
    }

    public List getTopLevelPages(Space space) {
        return this.findNamedQueryStringParam("confluence.page_findTopLevelPagesBySpace", "spaceid", new Long(space.getId()), true);
    }
}

