/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.thumbnail;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.util.bean.ImageInfo;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.spring.container.ContainerManager;
import java.io.InputStream;

public class ThumbnailInfo {
    private Attachment attachment;
    private ImageInfo imageInfo;
    private String attachmentsPath;
    private int configMaxWidth;
    private int configMaxHeight;
    public static final int THUMBNAIL_DEFAULT_WIDTH = 200;

    public static boolean systemSupportsThumbnailing() {
        Thumber t = new Thumber();
        return t.checkToolkit();
    }

    public ThumbnailInfo(Attachment attachment, InputStream attachmentData, String attachmentsPath) {
        this.attachment = attachment;
        this.attachmentsPath = attachmentsPath;
        this.imageInfo = new ImageInfo();
        this.imageInfo.setInput(attachmentData);
        this.imageInfo.setDetermineImageNumber(true);
        this.imageInfo.setCollectComments(true);
        this.imageInfo.isValidImage();
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        this.configMaxWidth = settingsManager.getGlobalSettings().getMaxThumbWidth();
        this.configMaxHeight = settingsManager.getGlobalSettings().getMaxThumbHeight();
    }

    public int getOriginalWidth() {
        return this.imageInfo.getWidth();
    }

    public int getOriginalHeight() {
        return this.imageInfo.getHeight();
    }

    public int getThumbnailWidth() {
        int possibleWidth = (int)Math.round((double)this.getOriginalWidth() * this.getFloorHeightRatio());
        return possibleWidth < this.configMaxWidth ? possibleWidth : this.configMaxWidth;
    }

    public int getThumbnailHeight() {
        int possibleHeight = (int)Math.round((double)this.getOriginalHeight() * this.getFloorWidthRatio());
        return possibleHeight < this.configMaxHeight ? possibleHeight : this.configMaxHeight;
    }

    public String getThumbnailUrlPath() {
        return this.getAttachmentUrl().replaceAll("/attachments/", "/thumbnails/");
    }

    @HtmlSafe
    public String getPopupLink(String imageParameters) {
        String openWindowJavascript = "window.open(\"" + this.getServerAttachmentUrl() + "\", \"" + this.attachment.getFileName() + "\", \"height=" + (this.getOriginalHeight() + 20) + ",width=" + (this.getOriginalWidth() + 20) + ",menubar=no,status=no,toolbar=no\"); return false;";
        return "<a href='" + this.getServerAttachmentUrl() + "' target='" + this.attachment.getFileName() + "' onClick='" + openWindowJavascript + "'>" + this.getThumbnailImageHtml(imageParameters) + "</a>";
    }

    @HtmlSafe
    public String getPopupLinkPrefix() {
        String openWindowJavascript = "window.open(\"" + this.getServerAttachmentUrl() + "\", \"" + this.attachment.getFileName() + "\", \"height=" + (this.getOriginalHeight() + 20) + ",width=" + (this.getOriginalWidth() + 20) + ",menubar=no,status=no,toolbar=no\"); return false;";
        return "<a href='" + this.getServerAttachmentUrl() + "' target='" + this.attachment.getFileName() + "' onClick='" + openWindowJavascript + "'>";
    }

    @HtmlSafe
    public String getPopupLinkSuffix() {
        return "</a>";
    }

    @HtmlSafe
    public String getThumbnailImageHtml(String imageParameters) {
        String extraParams = "";
        if (imageParameters == null || imageParameters.indexOf("border=") == -1) {
            extraParams = "border='0' ";
        }
        String result = "<img " + extraParams + "src='" + this.getThumbnailUrlPath() + "' ";
        if (this.getThumbnailWidth() > 0) {
            result = result + "width='" + this.getThumbnailWidth() + "' ";
        }
        if (this.getThumbnailHeight() > 0) {
            result = result + "height='" + this.getThumbnailHeight() + "' ";
        }
        result = result + this.mungeParameters(imageParameters) + ">";
        return result;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    private String mungeParameters(String imageParameters) {
        if (imageParameters == null) {
            return "";
        }
        return " " + imageParameters;
    }

    private double getFloorHeightRatio() {
        return this.getFloorRatio(this.getOriginalHeight(), this.configMaxHeight);
    }

    private double getFloorWidthRatio() {
        return this.getFloorRatio(this.getOriginalWidth(), this.configMaxWidth);
    }

    private double getFloorRatio(int actual, int desired) {
        if (actual <= desired) {
            return 1.0;
        }
        return (double)desired / (double)actual;
    }

    private String getAttachmentUrl() {
        StringBuffer url = new StringBuffer();
        if (this.attachmentsPath != null) {
            url.append(UrlUtil.escapeSpecialCharacters((String)this.attachmentsPath)).append("/");
        }
        url.append(UrlUtil.escapeSpecialCharacters((String)this.attachment.getFileName()));
        return url.toString();
    }

    private String getServerAttachmentUrl() {
        String serverPath = ConfluenceRenderUtils.getAbsoluteAttachmentRemotePath(this.attachment);
        serverPath = serverPath + "/" + this.attachment.getFileName();
        return UrlUtil.escapeSpecialCharacters((String)serverPath);
    }
}

