/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.thumbnail;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailInfo;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.renderer.embedded.ImagePathHelper;
import com.atlassian.confluence.util.io.IOUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Thumbnails {
    private List thumbnails = new ArrayList();
    private List rows;
    private int maxHeight;
    private int maxWidth;
    private int maxImageHeight;
    private int maxImageWidth;
    private int configuredColumns;

    public Thumbnails(List attachments, String attachmentsRoot, int columns, AttachmentManager attachmentManager, ThumbnailManager thumbnailManager) {
        this(attachments, new StaticImagePathHelper(attachmentsRoot), columns, attachmentManager, thumbnailManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thumbnails(List attachments, ImagePathHelper pathHelper, int columns, AttachmentManager attachmentManager, ThumbnailManager thumbnailManager) {
        this.configuredColumns = columns;
        for (Attachment attachment : attachments) {
            ThumbnailInfo thumbnail;
            if (!thumbnailManager.isThumbnailable(attachment)) continue;
            InputStream attachmentData = null;
            try {
                attachmentData = attachmentManager.getAttachmentData(attachment);
                if (attachmentData == null) continue;
                thumbnail = new ThumbnailInfo(attachment, attachmentData, pathHelper.getImagePath(attachment, true));
            }
            finally {
                IOUtils.close(attachmentData);
                continue;
            }
            if (thumbnail.getThumbnailHeight() > this.maxHeight) {
                this.maxHeight = thumbnail.getThumbnailHeight();
            }
            if (thumbnail.getThumbnailWidth() > this.maxWidth) {
                this.maxWidth = thumbnail.getThumbnailWidth();
            }
            if (thumbnail.getOriginalHeight() > this.maxImageHeight) {
                this.maxImageHeight = thumbnail.getOriginalHeight();
            }
            if (thumbnail.getOriginalWidth() > this.maxImageWidth) {
                this.maxImageWidth = thumbnail.getOriginalWidth();
            }
            this.thumbnails.add(thumbnail);
        }
    }

    public int getSize() {
        return this.thumbnails.size();
    }

    public List getThumbnails() {
        return this.thumbnails;
    }

    public List getRows() {
        if (this.rows == null) {
            this.rows = new ArrayList(this.getSize() / this.configuredColumns + 1);
            for (int idx = 0; idx < this.getSize(); idx += this.configuredColumns) {
                ArrayList row = new ArrayList(this.configuredColumns);
                for (int i = 0; i < this.configuredColumns; ++i) {
                    if (idx + i < this.thumbnails.size()) {
                        row.add(this.thumbnails.get(idx + i));
                        continue;
                    }
                    if (this.rows.size() <= 0) continue;
                    row.add("BLANK");
                }
                this.rows.add(row);
            }
        }
        return this.rows;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxImageHeight() {
        return this.maxImageHeight;
    }

    public int getMaxImageWidth() {
        return this.maxImageWidth;
    }

    public int getColumns() {
        if (this.getRows().size() == 0) {
            return 1;
        }
        return ((List)this.getRows().get(0)).size();
    }

    private static class StaticImagePathHelper
    implements ImagePathHelper {
        final String path;

        private StaticImagePathHelper(String str) {
            this.path = str;
        }

        public String getImagePath(Attachment attachment, boolean isThumbnail) {
            return this.path;
        }
    }
}

