/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.wysiwyg;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.pages.wysiwyg.ConfluenceWysiwygConverter;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.wysiwyg.WysiwygConverter;
import com.atlassian.spring.container.ContainerManager;

public class DefaultConfluenceWysiwygConverter
implements ConfluenceWysiwygConverter {
    private ContentEntityManager contentEntityManager;
    private WysiwygConverter converter;
    private WikiStyleRenderer wikiStyleRenderer;
    private SettingsManager settingsManager;
    private UserAccessor userAccessor;

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setWysiwygConverter(WysiwygConverter converter) {
        this.converter = converter;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public String convertXHtmlToWikiMarkup(ContentEntityObject content, String xhtml) {
        return this.convertXHtmlToWikiMarkup(xhtml);
    }

    private String convertXHtmlToWikiMarkup(String xhtml) {
        return this.converter.convertXHtmlToWikiMarkup(xhtml);
    }

    @HtmlSafe
    public String convertWikiMarkupToXHtml(ContentEntityObject content, String wikiMarkup) {
        return this.converter.convertWikiMarkupToXHtml((RenderContext)this.getPageContext(content, null), wikiMarkup);
    }

    @HtmlSafe
    public String convertXHtmlToWikiMarkupWithoutPage(String xhtml, String pageIdString) {
        return this.convertXHtmlToWikiMarkup(xhtml);
    }

    private long convertPageId(String pageIdString) {
        return Long.parseLong(pageIdString);
    }

    @HtmlSafe
    public String convertWikiMarkupToXHtmlWithoutPage(String wikiMarkup, String contentId) {
        return this.convertWikiMarkupToXHtml(this.contentEntityManager.getById(this.convertPageId(contentId)), wikiMarkup);
    }

    @HtmlSafe
    public String convertToPreview(String inputText, String contentId, String spaceKey, String fromMode) {
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(this.convertPageId(contentId));
        if (AbstractPageAction.RICHTEXT.equals(fromMode)) {
            inputText = this.convertXHtmlToWikiMarkup(contentEntityObject, inputText);
        }
        PageContext context = this.getPageContext(contentEntityObject, spaceKey);
        context.setOutputType("preview");
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, inputText);
    }

    private PageContext getPageContext(ContentEntityObject contentEntityObject, String spaceKey) {
        return contentEntityObject == null ? new PageContext(spaceKey) : contentEntityObject.toPageContext();
    }

    public boolean getUserWysiwygPreference() {
        boolean useGlobalPreference = false;
        boolean useWysiwyg = false;
        UserPreferences userPreferences = new UserPreferences(this.getUserAccessor().getPropertySet(AuthenticatedUserThreadLocal.getUser()));
        try {
            useGlobalPreference = userPreferences.getString("confluence.user.runtime.edit-wysiwyg") == null;
        }
        catch (Exception ipte) {
            useGlobalPreference = false;
        }
        useWysiwyg = !useGlobalPreference ? userPreferences.getBoolean("confluence.user.runtime.edit-wysiwyg") : this.settingsManager.getGlobalSettings().isUseWysiwygByDefault();
        return useWysiwyg;
    }

    private UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }
}

