/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluencePluginUtils {
    private static final Logger log = Logger.getLogger(ConfluencePluginUtils.class);

    public static File getPluginDirectory(BootstrapManager bootstrapManager) {
        File pluginsDirectory = new File(bootstrapManager.getConfluenceHome() + File.separator + "plugins");
        if (!pluginsDirectory.exists()) {
            pluginsDirectory.mkdirs();
        }
        return pluginsDirectory;
    }

    public static File getPluginTempDirectory(BootstrapManager bootstrapManager) {
        File pluginsDirectory = new File(bootstrapManager.getConfluenceHome() + File.separator + "plugins-temp");
        if (!pluginsDirectory.exists()) {
            pluginsDirectory.mkdirs();
        }
        return pluginsDirectory;
    }

    public static File getBundledPluginDirectory(BootstrapManager bootstrapManager) {
        File bundledPluginsDirectory = new File(bootstrapManager.getConfluenceHome() + File.separator + "bundled-plugins");
        if (!bundledPluginsDirectory.exists()) {
            bundledPluginsDirectory.mkdirs();
        }
        return bundledPluginsDirectory;
    }

    public static <T> T instantiatePluginModule(Plugin plugin, Class<T> cls) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instantiating module '" + cls.getSimpleName() + "' for plugin '" + plugin.getName() + "' Version: " + plugin.getPluginsVersion() + " Description: " + plugin.getPluginInformation().getDescription() + " Key: " + plugin.getKey()));
        }
        if (plugin instanceof AutowireCapablePlugin) {
            return (T)((AutowireCapablePlugin)plugin).autowire(cls);
        }
        return (T)ContainerManager.getInstance().getContainerContext().createComponent(cls);
    }
}

