/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.opensymphony.util.TextUtils;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.dom4j.Element;

public class ColourSchemeModuleDescriptor
extends AbstractModuleDescriptor {
    private static final Category log = Category.getInstance(ColourSchemeModuleDescriptor.class);
    private static final Map TRANSLATOR = new HashMap();
    private Map colours = new HashMap();

    public Object getModule() {
        Class clazz = this.getModuleClass();
        try {
            Constructor ctor = clazz.getConstructor(Map.class);
            return ctor.newInstance(new HashMap(this.colours));
        }
        catch (Exception e) {
            log.error((Object)("Unable to instantiate plugin colour scheme key: " + this.getCompleteKey() + " of class: " + ((Object)((Object)this)).getClass().getName() + " message: " + e.toString()), (Throwable)e);
            return null;
        }
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.extractColours(element, "color");
        this.extractColours(element, "colour");
    }

    private void extractColours(Element element, String tagName) throws PluginParseException {
        List definedColours = element.elements(tagName);
        for (Element colour : definedColours) {
            String key = colour.attributeValue("key");
            String value = colour.attributeValue("value");
            if (!TextUtils.stringSet((String)key) || !TextUtils.stringSet((String)value)) {
                throw new PluginParseException("Malformed colour module: colours must have key and value");
            }
            if (TRANSLATOR.containsKey(key)) {
                key = (String)TRANSLATOR.get(key);
            }
            if (this.colours.containsKey(key)) {
                log.warn((Object)("Colour scheme " + this.getCompleteKey() + " contains multiple definitions for colour: " + colour.attributeValue("key")));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getCompleteKey() + " " + key + ": " + value));
            }
            this.colours.put(key, value);
        }
    }

    static {
        TRANSLATOR.put("topbar", "property.style.topbarcolour");
        TRANSLATOR.put("spacename", "property.style.spacenamecolour");
        TRANSLATOR.put("headingtext", "property.style.headingtextcolour");
        TRANSLATOR.put("link", "property.style.linkcolour");
        TRANSLATOR.put("border", "property.style.bordercolour");
        TRANSLATOR.put("navbg", "property.style.navbgcolour");
        TRANSLATOR.put("navtext", "property.style.navtextcolour");
        TRANSLATOR.put("navselectedbg", "property.style.navselectedbgcolour");
        TRANSLATOR.put("navselectedtext", "property.style.navselectedtextcolour");
    }
}

