/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class DecoratorModuleDescriptor
extends AbstractModuleDescriptor {
    private Pattern pattern;
    private String page;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attribute("page") == null) {
            throw new PluginParseException("No 'page' attribute specified for decorator module " + this.getName());
        }
        this.page = element.attributeValue("page");
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            if (!child.getName().equals("pattern")) continue;
            if (this.pattern != null) {
                throw new PluginParseException("Multiple patterns specified for decorator module " + this.getName());
            }
            String patternText = child.node(0).getText();
            this.pattern = Pattern.compile(patternText.replaceAll("\\*", ".*"));
        }
    }

    public Object getModule() {
        return null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPage() {
        return this.page;
    }
}

