/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ExtractorModuleDescriptor
extends AbstractModuleDescriptor
implements Comparable {
    public static final Logger log = Logger.getLogger(ExtractorModuleDescriptor.class);
    Extractor extractor;
    private int priority;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.priority = this.determinePriority(element);
        if (this.priority <= 0) {
            log.warn((Object)("Unable to determine priority for extractor module " + this.getCompleteKey()));
            this.priority = 10;
        }
    }

    private int determinePriority(Element element) {
        String value;
        Attribute att = element.attribute("priority");
        if (att != null && StringUtils.isNotBlank((String)(value = att.getValue()))) {
            return TextUtils.parseInt((String)value);
        }
        return 0;
    }

    public Object getModule() {
        if (this.extractor == null) {
            this.extractor = new BackwardsCompatibleExtractor((Extractor)ConfluencePluginUtils.instantiatePluginModule(this.plugin, this.getModuleClass()));
        }
        return this.extractor;
    }

    public int getPriority() {
        return this.priority;
    }

    public int compareTo(Object o) {
        ExtractorModuleDescriptor otherDesc = (ExtractorModuleDescriptor)o;
        if (otherDesc.priority != this.priority) {
            return otherDesc.priority - this.priority;
        }
        return this.getCompleteKey().compareTo(otherDesc.getCompleteKey());
    }

    private class BackwardsCompatibleExtractor
    implements Extractor {
        private final Extractor delegate;

        public BackwardsCompatibleExtractor(Extractor delegate) {
            this.delegate = delegate;
        }

        public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
            try {
                this.delegate.addFields(document, defaultSearchableText, searchable);
            }
            catch (LinkageError error) {
                log.error((Object)("Unable to completely index " + searchable + ".\n\nPlugin module " + ExtractorModuleDescriptor.this.getCompleteKey() + " is incompatible with this version of Confluence. " + "You will need to upgrade to a newer version of the " + ExtractorModuleDescriptor.this.getPlugin().getName() + " plugin. " + error), (Throwable)error);
            }
        }

        public String toString() {
            return "BackwardsCompatibleExtractor wrapping " + this.delegate.toString() + " (" + ExtractorModuleDescriptor.this.getCompleteKey() + ")";
        }
    }
}

