/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.opensymphony.util.TextUtils;
import org.dom4j.Element;

public class LanguageModuleDescriptor
extends AbstractModuleDescriptor {
    private String encoding;
    private String language;
    private String country;
    private String variant;
    private boolean licensed;
    private Language languageModule;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attribute("language") != null) {
            this.setLanguage(element.attribute("language").getText());
        }
        if (element.attribute("country") != null) {
            this.setCountry(element.attribute("country").getText());
        }
        if (element.attribute("variant") != null) {
            this.setVariant(element.attribute("variant").getText());
        }
        if (element.attribute("encoding") != null) {
            this.setEncoding(element.attribute("encoding").getText());
        }
        this.licensed = GeneralUtil.getBuildExcludedLocale() == null || GeneralUtil.getBuildExcludedLocale().indexOf(element.attribute("key").getValue()) <= -1;
        if (element.attribute("language") == null || !TextUtils.stringSet((String)element.attribute("language").getValue())) {
            throw new PluginParseException("Module " + this.getCompleteKey() + " must define an \"language\" attribute");
        }
    }

    public Object getModule() {
        if (this.languageModule == null) {
            this.languageModule = new Language(this);
        }
        return this.languageModule;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public boolean isLicensed() {
        return this.licensed;
    }
}

