/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.event.DeprecatedEventListenerWrapper;
import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.util.AopUtils;
import com.atlassian.event.EventListener;
import com.atlassian.event.EventManager;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import org.apache.log4j.Logger;

public class ListenerModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware {
    private static Logger log = Logger.getLogger(ListenerModuleDescriptor.class);
    private EventListener eventListener;
    private EventManager eventManager;

    public Object getModule() {
        if (this.eventListener == null) {
            Class listenerClass = this.getModuleClass();
            Object listenerObject = ConfluencePluginUtils.instantiatePluginModule(this.plugin, listenerClass);
            if (com.atlassian.confluence.event.EventListener.class.isAssignableFrom(listenerClass)) {
                log.info((Object)("Plugin: " + this.getCompleteKey() + " is using an outdated, deprecated version of the API - EventListener. Inform the plugin author to upgrade."));
                DeprecatedEventListenerWrapper delegate = new DeprecatedEventListenerWrapper((com.atlassian.confluence.event.EventListener)listenerObject);
                listenerObject = AopUtils.adaptInterface(listenerObject, EventListener.class, com.atlassian.confluence.event.EventListener.class, delegate);
            }
            this.eventListener = (EventListener)listenerObject;
        }
        return this.eventListener;
    }

    public void enabled() {
        EventListener eventListener = (EventListener)this.getModule();
        if (eventListener instanceof StateAware) {
            StateAware stateAware = (StateAware)eventListener;
            stateAware.enabled();
        }
        this.eventManager.registerListener(this.getCompleteKey(), eventListener);
    }

    public void disabled() {
        this.eventManager.unregisterListener(this.getCompleteKey());
        EventListener eventListener = (EventListener)this.getModule();
        if (eventListener instanceof StateAware) {
            StateAware stateAware = (StateAware)eventListener;
            stateAware.disabled();
        }
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

