/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Category;
import org.dom4j.Element;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class TriggerModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware {
    private static final Category log = Category.getInstance(TriggerModuleDescriptor.class);
    String jobKey;
    Scheduler scheduler;
    Trigger trigger;
    JobDetail jobDetail;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Element jobEl = element.element("job");
        if (jobEl == null || jobEl.attribute("key") == null) {
            throw new PluginParseException("You must specify a <job key=\"\" /> for trigger plugin modules.");
        }
        this.jobKey = jobEl.attributeValue("key");
        Element scheduleEl = element.element("schedule");
        if (scheduleEl == null) {
            throw new PluginParseException("You must specify a <schedule /> for trigger plugin modules.");
        }
        if (scheduleEl.attribute("cron-expression") != null) {
            CronTrigger cronTrigger = new CronTrigger();
            try {
                cronTrigger.setCronExpression(scheduleEl.attributeValue("cron-expression"));
            }
            catch (ParseException e) {
                throw new PluginParseException("Invalid cron-expression specified: " + e, (Throwable)e);
            }
            this.trigger = cronTrigger;
        } else {
            SimpleTrigger simpleTrigger = new SimpleTrigger();
            if (scheduleEl.attribute("repeat-interval") != null) {
                simpleTrigger.setRepeatInterval(Long.parseLong(scheduleEl.attributeValue("repeat-interval")));
            }
            if (scheduleEl.attribute("repeat-count") != null) {
                simpleTrigger.setRepeatCount(Integer.parseInt(scheduleEl.attributeValue("repeat-count")));
            }
            this.trigger = simpleTrigger;
        }
        this.trigger.setStartTime(new Date());
        this.trigger.setGroup(this.getCompleteKey());
        this.trigger.setName(this.getKey());
    }

    public Object getModule() {
        return null;
    }

    public void enabled() {
        try {
            if (this.getJobDetail() != null) {
                this.trigger.setJobName(this.getJobDetail().getName());
                this.trigger.setJobGroup(this.getJobDetail().getGroup());
                this.scheduler.scheduleJob(this.getJobDetail(), this.trigger);
            }
        }
        catch (SchedulerException e) {
            log.error((Object)("Error scheduling job: " + this.getCompleteKey() + ": " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void disabled() {
        try {
            if (this.getJobDetail() != null) {
                this.scheduler.deleteJob(this.getJobDetail().getName(), this.getJobDetail().getGroup());
            }
        }
        catch (SchedulerException e) {
            log.error((Object)("Error deleting job: " + this.getCompleteKey() + ": " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    private JobDetail getJobDetail() {
        if (this.jobDetail == null) {
            ModuleDescriptor jobModuleDescriptor = this.plugin.getModuleDescriptor(this.jobKey);
            Object o = jobModuleDescriptor.getModule();
            if (o instanceof JobDetail) {
                this.jobDetail = (JobDetail)o;
            } else {
                log.error((Object)("Job key " + this.jobKey + " does not reference a valid job."));
            }
        }
        return this.jobDetail;
    }
}

