/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.web;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.UserLocaleAware;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;

public class ConfluenceWebFragmentHelper
implements WebFragmentHelper,
UserLocaleAware {
    private I18NBeanFactory i18NBeanFactory;

    public Object loadComponent(String className, Plugin plugin) throws ConditionLoadingException {
        try {
            Class cls = plugin.loadClass(className, this.getClass());
            return ConfluencePluginUtils.instantiatePluginModule(plugin, cls);
        }
        catch (Exception e) {
            throw new ConditionLoadingException((Throwable)e);
        }
    }

    public Condition loadCondition(String className, Plugin plugin) throws ConditionLoadingException {
        return (Condition)this.loadComponent(className, plugin);
    }

    public ContextProvider loadContextProvider(String className, Plugin plugin) throws ConditionLoadingException {
        return (ContextProvider)this.loadComponent(className, plugin);
    }

    public String getI18nValue(String key, List arguments, Map context) {
        return this.i18NBeanFactory.getI18NBean().getText(key, arguments);
    }

    public String renderVelocityFragment(String fragment, Map context) {
        if (!this.needToRender(fragment)) {
            return fragment;
        }
        return VelocityUtils.getRenderedContent(fragment, this.getContext(context));
    }

    private Map getContext(Map context) {
        Map result = MacroUtils.defaultVelocityContext();
        if (context != null) {
            result.putAll(context);
        }
        if (!result.containsKey("helper")) {
            ConfluenceActionSupport action = (ConfluenceActionSupport)result.get("action");
            result.put("helper", action.getHelper());
        }
        return result;
    }

    private boolean needToRender(String velocity) {
        return TextUtils.stringSet((String)velocity) && (velocity.indexOf("$") >= 0 || velocity.indexOf("#") >= 0);
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }
}

