/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.web.conditions;

import com.atlassian.confluence.plugin.descriptor.web.conditions.AbstractConfluenceCondition;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.user.User;
import java.util.Map;

public abstract class AbstractPermissionCondition
extends AbstractConfluenceCondition {
    private PermissionManager permissionManager;
    private Permission permission = null;

    public void init(Map params) throws PluginParseException {
        try {
            this.permission = Permission.forName((String)params.get("permission"));
        }
        catch (Exception e) {
            throw new PluginParseException("Could not determine permission for condition. " + e.getMessage(), (Throwable)e);
        }
        super.init(params);
    }

    public boolean shouldDisplay(User user, GlobalHelper helper) {
        return this.permissionManager.hasPermission(user, this.permission, this.getPermissionTarget(helper));
    }

    protected abstract Object getPermissionTarget(GlobalHelper var1);

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

