/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.persistence.hibernate;

import com.atlassian.confluence.plugin.persistence.PluginData;
import com.atlassian.confluence.plugin.persistence.PluginDataDao;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class HibernatePluginDataDao
extends HibernateDaoSupport
implements PluginDataDao {
    public PluginData getPluginData(String key) throws ObjectRetrievalFailureException {
        List results = this.findPluginData(key);
        if (results.isEmpty()) {
            throw new ObjectRetrievalFailureException(PluginData.class, (Object)key);
        }
        return (PluginData)results.get(0);
    }

    private List findPluginData(String key) {
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam("confluence.pd_findPluginDataByKey", "key", (Object)key);
    }

    public Iterator getAllPluginData() {
        Query namedQuery;
        try {
            namedQuery = this.getSession().getNamedQuery("confluence.pd_getAllPluginData");
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
        return this.getHibernateTemplate().iterate(namedQuery.getQueryString());
    }

    public void saveOrUpdate(PluginData pluginData) {
        pluginData.setLastModificationDate(new Date());
        this.getHibernateTemplate().saveOrUpdate((Object)pluginData);
        try {
            this.getSession().flush();
            this.getSession().evict((Object)pluginData);
        }
        catch (HibernateException e) {
            throw new RuntimeException("There was a problem evicting or flushing a PluginData object", e);
        }
    }

    public void remove(String key) throws ObjectRetrievalFailureException {
        this.getHibernateTemplate().delete((Object)this.getPluginData(key));
    }

    public boolean pluginDataExists(String key) {
        return !this.findPluginData(key).isEmpty();
    }
}

