/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.webresource;

import com.atlassian.confluence.plugin.webresource.CssResourceCounterManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfluenceWebResourceIntegration
implements WebResourceIntegration {
    private static Logger log = Logger.getLogger(ConfluenceWebResourceIntegration.class);
    private PluginAccessor pluginAccessor;
    private SettingsManager settingsManager;
    private CssResourceCounterManager cssResourceCounterManager;

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public Map getRequestCache() {
        return RequestCacheThreadLocal.getRequestCache();
    }

    public String getSystemCounter() {
        if (Boolean.getBoolean("atlassian.disable.caches")) {
            return String.valueOf((int)(Math.random() * 100000.0) + 1);
        }
        return String.valueOf(this.cssResourceCounterManager.getGlobalCssResourceCounter());
    }

    public String getSystemBuildNumber() {
        return GeneralUtil.getBuildNumber();
    }

    public String getBaseUrl() {
        try {
            if (ServletActionContext.getRequest() != null && ServletActionContext.getRequest().getContextPath() != null) {
                return ServletActionContext.getRequest().getContextPath();
            }
        }
        catch (NullPointerException e) {
            log.warn((Object)"ServletActionContext.getRequest().getContextPath() threw NullPointerException. Ignoring.", (Throwable)e);
        }
        if (RequestCacheThreadLocal.getContextPath() != null) {
            return RequestCacheThreadLocal.getContextPath();
        }
        if (this.settingsManager.getGlobalSettings().getBaseUrl() != null) {
            return this.settingsManager.getGlobalSettings().getBaseUrl();
        }
        log.error((Object)"No non-null base URL found");
        return null;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setCssResourceCounterManager(CssResourceCounterManager cssResourceCounterManager) {
        this.cssResourceCounterManager = cssResourceCounterManager;
    }
}

