/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.renderer.ShortcutLinkConfig;
import com.atlassian.confluence.renderer.ShortcutLinksManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.core.util.PropertyUtils;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DefaultShortcutLinksManager
implements ShortcutLinksManager {
    private static final Logger log = Logger.getLogger(DefaultShortcutLinksManager.class);
    BandanaManager bandanaManager;

    public Map getShortcutLinks() {
        Map shortcutLinks = (Map)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.shortcut.links");
        if (shortcutLinks == null) {
            shortcutLinks = this.getDefaults();
        }
        return shortcutLinks;
    }

    public void addShortcutLink(String key, ShortcutLinkConfig shortcutLinkConfig) {
        Map shortcutLinks = this.getShortcutLinks();
        shortcutLinks.put(key.toLowerCase(), shortcutLinkConfig);
        this.updateShortcutLinks(shortcutLinks);
    }

    public void removeShortcutLink(String key) {
        Map shortcutLinks = this.getShortcutLinks();
        shortcutLinks.remove(key);
        this.updateShortcutLinks(shortcutLinks);
    }

    public void updateShortcutLinks(Map shortcutLinks) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.shortcut.links", (Object)shortcutLinks);
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public boolean hasShortcutLink(String key) {
        if (TextUtils.stringSet((String)key)) {
            return this.getShortcutLinks().containsKey(key.toLowerCase());
        }
        return false;
    }

    public ShortcutLinkConfig getShortcutLinkConfig(String key) {
        Object o = this.getShortcutLinks().get(key.toLowerCase());
        if (o instanceof ShortcutLinkConfig) {
            ShortcutLinkConfig shortcutLinkConfig = (ShortcutLinkConfig)o;
            return shortcutLinkConfig;
        }
        if (o instanceof String) {
            ShortcutLinkConfig shortcutLinkConfig = new ShortcutLinkConfig();
            shortcutLinkConfig.setExpandedValue((String)o);
            return shortcutLinkConfig;
        }
        if (o == null) {
            return null;
        }
        log.warn((Object)("Object of type " + o.getClass() + " found instead of a ShortcutLinkConfig for key: " + key));
        return null;
    }

    private Map getDefaults() {
        HashMap<Object, ShortcutLinkConfig> result = new HashMap<Object, ShortcutLinkConfig>();
        Properties defaultProperties = PropertyUtils.getProperties((String)"default-shortcut-map.properties", this.getClass());
        for (Map.Entry<Object, Object> entry : defaultProperties.entrySet()) {
            ShortcutLinkConfig linkConfig = new ShortcutLinkConfig();
            linkConfig.setExpandedValue((String)entry.getValue());
            result.put(entry.getKey(), linkConfig);
        }
        return result;
    }
}

