/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.embedded;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.embedded.EmbeddedResourceUtils;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.embedded.EmbeddedObject;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.util.UrlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmbeddedObjectRenderer
implements EmbeddedResourceRenderer {
    public static String TEMPLATE_PATH = "com/atlassian/confluence/renderer/embeddedobject.vm";
    public static String WRAPPER_TEMPLATE_PATH = "com/atlassian/confluence/renderer/embeddedobject-wrapper.vm";
    protected static List validObjectTags = new ArrayList();
    protected static List validEmbedTags;
    protected static List validParamTags;

    protected Map setupObjectProperties(EmbeddedResource resource, RenderContext context) {
        EmbeddedObject emObject = (EmbeddedObject)resource;
        Attachment attachment = null;
        attachment = EmbeddedResourceUtils.resolveAttachment((PageContext)context, (EmbeddedResource)emObject);
        if (attachment == null) {
            throw new IllegalArgumentException("Unable to render embedded object: File (" + emObject.getFilename() + ") not found.");
        }
        HashMap<Object, Object> objectParams = new HashMap<Object, Object>();
        objectParams.putAll(emObject.getProperties());
        objectParams.put("type", resource.getType());
        String objectUrl = "";
        String attachmentsPath = context.getAttachmentsPath();
        if (attachmentsPath == null) {
            attachmentsPath = attachment != null ? ConfluenceRenderUtils.getAttachmentRemotePath(attachment) : ConfluenceRenderUtils.getAttachmentsRemotePath((PageContext)context);
        }
        if (attachmentsPath != null) {
            objectUrl = UrlUtil.escapeSpecialCharacters((String)attachmentsPath) + "/";
        }
        objectUrl = objectUrl + UrlUtil.escapeSpecialCharacters((String)emObject.getFilename());
        objectParams.put("object", objectUrl);
        objectParams.put("src", objectUrl);
        objectParams.put("data", objectUrl);
        return objectParams;
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        Map contextMap = this.setupObjectProperties(resource, context);
        HashMap<String, Object> wrapperContextMap = new HashMap<String, Object>();
        wrapperContextMap.put("properties", contextMap);
        wrapperContextMap.put("validObjectTags", validObjectTags);
        wrapperContextMap.put("validEmbedTags", validEmbedTags);
        wrapperContextMap.put("validParamTags", validParamTags);
        String renderedObjectHtml = VelocityUtils.getRenderedTemplate(TEMPLATE_PATH, wrapperContextMap);
        wrapperContextMap.put("embeddedObject", renderedObjectHtml);
        return VelocityUtils.getRenderedTemplate(WRAPPER_TEMPLATE_PATH, wrapperContextMap);
    }

    static {
        validObjectTags.add("align");
        validObjectTags.add("archive");
        validObjectTags.add("border");
        validObjectTags.add("class");
        validObjectTags.add("classid");
        validObjectTags.add("codebase");
        validObjectTags.add("codetype");
        validObjectTags.add("data");
        validObjectTags.add("declare");
        validObjectTags.add("dir");
        validObjectTags.add("height");
        validObjectTags.add("hspace");
        validObjectTags.add("id");
        validObjectTags.add("lang");
        validObjectTags.add("name");
        validObjectTags.add("standby");
        validObjectTags.add("style");
        validObjectTags.add("tabindex");
        validObjectTags.add("title");
        validObjectTags.add("type");
        validObjectTags.add("usemap");
        validObjectTags.add("vspace");
        validObjectTags.add("width");
        validEmbedTags = new ArrayList();
        validEmbedTags.add("align");
        validEmbedTags.add("autostart");
        validEmbedTags.add("bgcolor");
        validEmbedTags.add("controller");
        validEmbedTags.add("controls");
        validEmbedTags.add("console");
        validEmbedTags.add("class");
        validEmbedTags.add("height");
        validEmbedTags.add("href");
        validEmbedTags.add("id");
        validEmbedTags.add("name");
        validEmbedTags.add("pluginspage");
        validEmbedTags.add("pluginurl");
        validEmbedTags.add("quality");
        validEmbedTags.add("showcontrols");
        validEmbedTags.add("showtracker");
        validEmbedTags.add("showdisplay");
        validEmbedTags.add("src");
        validEmbedTags.add("target");
        validEmbedTags.add("type");
        validEmbedTags.add("width");
        validParamTags = new ArrayList();
        validParamTags.add("animationatStart");
        validParamTags.add("autoStart");
        validParamTags.add("controller");
        validParamTags.add("controls");
        validParamTags.add("console");
        validParamTags.add("data");
        validParamTags.add("fileName");
        validParamTags.add("href");
        validParamTags.add("loop");
        validParamTags.add("menu");
        validParamTags.add("movie");
        validParamTags.add("quality");
        validParamTags.add("scale");
        validParamTags.add("showControls");
        validParamTags.add("src");
        validParamTags.add("target");
        validParamTags.add("transparentatStart");
        validParamTags.add("type");
    }
}

