/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.v2.macros;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class GenericVelocityMacro
extends BaseMacro {
    String name;
    String velocity;
    PageManager pageManager;
    SpaceManager spaceManager;
    SubRenderer subRenderer;
    RenderMode bodyRenderMode = RenderMode.NO_RENDER;
    boolean hasBody;
    boolean renderOutput;
    private BootstrapManager bootstrapManager;

    public void setVelocity(String velocity) {
        this.velocity = velocity;
    }

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return this.hasBody;
    }

    public void setHasBody(boolean hasBody) {
        this.hasBody = hasBody;
    }

    public RenderMode getBodyRenderMode() {
        return this.bodyRenderMode;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        for (Map.Entry entry : parameters.entrySet()) {
            contextMap.put("param" + entry.getKey(), entry.getValue());
        }
        if (TextUtils.stringSet((String)body)) {
            contextMap.put("body", body);
        }
        contextMap.put("config", this.bootstrapManager);
        contextMap.put("renderContext", renderContext);
        if (renderContext instanceof PageContext) {
            PageContext context = (PageContext)renderContext;
            if (context.getEntity() != null) {
                contextMap.put("content", context.getEntity());
            }
            if (context.getSpaceKey() != null) {
                contextMap.put("space", this.spaceManager.getSpace(context.getSpaceKey()));
            }
        }
        String output = VelocityUtils.getRenderedContent(this.velocity, contextMap);
        if (this.renderOutput) {
            output = this.subRenderer.render(output, renderContext);
        }
        return output;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public boolean suppressSurroundingTagDuringWysiwygRendering() {
        return false;
    }

    public boolean suppressMacroRenderingDuringWysiwyg() {
        return true;
    }

    public void setRenderOutput(boolean renderOutput) {
        this.renderOutput = renderOutput;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public void setBodyRenderMode(RenderMode bodyRenderMode) {
        this.bodyRenderMode = bodyRenderMode;
    }

    public String getTemplate() {
        return this.velocity;
    }

    public boolean isRenderOutput() {
        return this.renderOutput;
    }
}

